part of book_detail;

class BuildStudy extends StatefulWidget {
  final BookDetailModel model;
  const BuildStudy({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  State<BuildStudy> createState() => _BuildStudyState();
}

class _BuildStudyState extends State<BuildStudy> {
  @override
  Widget build(BuildContext context) {
    return Container(
      height: 50.w,
      color: Colors.white,
      child:Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          Expanded(
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Text(widget.model.rating??'',style: TextStyle(fontSize: 18.w,height: 1.5,fontWeight: Fonts.medium,color: AppTheme.primary)),
                    Text('/5.0',style: TextStyle(fontSize: 18.w,height: 1.5,fontWeight: Fonts.medium,color: Colours.c9),)
                  ],
                ),
                widget.model.rating!=null?
                AbsorbPointer(
                  absorbing: true,
                  child: CustomRating(
                    max: 5,
                    score:double.parse(widget.model.rating!),
                    star: Star(
                      progress: 7,
                      fillColor: AppTheme.primary,
                      size: 12.w,
                      emptyColor: Colours.cE2,
                    ), onRating: (double a) {},
                  ),
                ):const SizedBox(),
              ],
            ),
          ),
          Expanded(
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                RichText(text:TextSpan(
                  children: [
                    TextSpan(
                      text: widget.model.readNum.toString(),
                      style: TextStyle(fontSize: 17.w,color: Colours.c3,fontWeight: Fonts.medium,height: 1.3)
                    ),
                    // TextSpan(
                    //   text: '万',
                    //     style: TextStyle(fontSize: 16,color: Colours.c3,)
                    // )
                  ]
                )),
                Text('学习人数', style: TextStyle(fontSize: 15.w,color: Colours.c9,height: 1.3)),
              ],
            ),
          )
        ],
      ) ,
    );
  }
}
