part of user_order_refunded;

/// 已完成订单
class UserOrderCRefundedController extends GetxController {
  final String orderNum;// 订单编号
  UserOrderCRefundedController(this.orderNum);

  OrderInfoModel model = OrderInfoModel();
  // 应付款、订单编号等
  List<OrderCompletedModel> orderCompleteds = [];


  @override
  void onReady() {
    getOrderInfo();
    super.onReady();
  }






  /// 获取订单信息
  void getOrderInfo() async {
    model = await MineAPI.getOrderInfo(orderNum: orderNum);
    String payWay ='';
    if(model.payType==1){
      payWay='微信';
    }else  if(model.payType==2){
      payWay='支付宝';
    }else  if(model.payType==3){
      payWay='紫荆币';
    }
    orderCompleteds = [
      OrderCompletedModel(name: '应付款',value: model.finalTotalPrice.toString(),
          other: (double.parse(model.totalPrice.toString())-
              double.parse(model.finalTotalPrice.toString())).toString()),
      OrderCompletedModel(name: '订单编号',value: model.ordersnum.toString()),
      OrderCompletedModel(name: '支付方式',value: payWay),
      OrderCompletedModel(name: '支付时间',value: model.payTime.toString()),
      OrderCompletedModel(name: '下单时间',value: model.createTime.toString()),
      OrderCompletedModel(name: '退款时间',value: model.refundTime.toString()),
    ];

    update();
  }

}
