part of mine;

/// 用户信息
class BuildUser extends StatelessWidget {

  final void Function()? onTap;
  final UserInfoModel userInfo;

  const BuildUser ({
    super.key,
    this.onTap,
    required this.userInfo
  });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      behavior: HitTestBehavior.opaque,
      onTap:onTap,
      child: Container(
        margin: const EdgeInsets.only(left: 10,right: 10),
        color: Colors.transparent,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Row(
              children: [
                Container(
                  width: 45.w,
                  height: 45.w,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(22.5),
                    color: Colors.cyan,
                  ),
                  // color: Colors.cyan,
                  child: CustomImage.network(url: userInfo.headImg??'',radius: 22.5,),
                ),
                Gaps.hGaps10,
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        Text(userInfo.name??'',style: TextStyle(
                            color: Colours.c3,
                            fontSize: 15.w,
                            fontWeight: Fonts.medium,
                            height: 1.6.w
                        ),),
                        Gaps.hGaps20,
                        Stack(
                          children: [
                            Container(
                              padding: const EdgeInsets.only(right:8,left: 8),
                              height: 20,
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(21),
                                gradient: LinearGradient(
                                  colors: [AppTheme.primary.withOpacity(0.03),AppTheme.primary.withOpacity(0.1)] , // 不可点击时的颜色，透明度为0.7
                                  begin: Alignment.centerLeft,
                                  end: Alignment.centerRight,
                                ),
                              ),
                              child: Row(
                                children: [
                                  const SizedBox(
                                    width: 16,
                                    height: 17,
                                  ),
                                  Text(userInfo.gradeName??'',style: const TextStyle(fontSize: 11,color: AppTheme.primary),)
                                ],
                              ),
                            ),
                            Positioned(
                              left: 8,
                              child: SizedBox(
                                  width: 16, height:17,
                                  child: Image.asset('assets/images/grade.png')
                              ),
                            )
                          ],
                        )
                      ],
                    ),
                    Gaps.vGaps5,
                    Text(userInfo.phone??'',style: TextStyle(
                        fontSize: 12.w,
                        color: Colours.c6
                    ),)
                  ],
                ),
                Gaps.hGaps20,
              ],
            ),
            SizedBox(
              width: 5,
              height: 9,
              child: Image.asset('assets/images/right_arrow.png'),
            )
          ],
        ),
      ),
    );
  }
}
