part of user_order_evaluate;

/// 用户订单评价
class UserOrderEvaluatePage extends StatefulWidget {

  final String orderNum; // 订单号
  final OrderInfoModel orderInfoModel; // 订单详情
  const UserOrderEvaluatePage({
    Key? key,
    required this.orderNum,
    required this.orderInfoModel,
  }) : super(key: key);

  @override
  State<UserOrderEvaluatePage> createState() => _UserOrderEvaluatePageState();
}

class _UserOrderEvaluatePageState extends State<UserOrderEvaluatePage> with AutomaticKeepAliveClientMixin{
  // late UserOrderEvaluateController myController;
  List<OrderEvaluate> orderEvaluates = [];
  List<double> ratings = [];
  @override
  void initState() {
      // myController = Get.put(UserOrderEvaluateController(widget.orderNum));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    // super.build(context);
    return
      GetBuilder<UserOrderEvaluateController>(
          init: UserOrderEvaluateController(widget.orderNum),
          builder: (controller) =>  Scaffold(
            appBar: AppBar(
              centerTitle: true,
              title: const Text('订单评价'),
            ),
            body:(controller.orderInfoModel==null ||controller.orderInfoModel.bookList==null)?
            Container(
              alignment: Alignment.center,
              child: const CircularProgressIndicator(),):
            Column(
              children: [
                Expanded(
                  child: Container(child: SingleChildScrollView(
                    child: Column(
                      children: [
                        ListView.builder(
                          physics: const NeverScrollableScrollPhysics(),
                          shrinkWrap: true,
                          itemBuilder: (BuildContext context, int index) {
                            return listItem(
                                controller.orderInfoModel.bookList![index],index,controller
                              /*orderEvaluates,*//*controllers*/);
                          },
                          itemCount:
                          controller.orderInfoModel.bookList?.length,
                        ),
                      ],
                    ),
                  ),),
                ),
                SizedBox(
                  height: 26.w,
                ),
                Container(
                  margin: EdgeInsets.symmetric(horizontal: 10.w),
                  child: CustomGradientButton(
                    text: '提交评价',
                    isEnabled: controller.enable,
                    onPressed: () {
                      controller._focusNode.unfocus();
                      for(int i=0;i<orderEvaluates.length;i++){
                        // orderEvaluates[i].comments=controllers[i].text.toString();
                      }
                      print(jsonEncode(orderEvaluates));
                      controller.UpOrderEvaluate(jsonEncode(orderEvaluates));
                    },
                  ),
                ),
                SizedBox(
                  height: 41.w,
                )
              ],
            ),




          ),);



  }

  Widget listItem(BookListModel bookListModel,int index,UserOrderEvaluateController myController) {
    int indexToUpdate = orderEvaluates.indexWhere((obj) => obj.recordId == bookListModel.recordId);
    myController.commentsInput.text =bookListModel.comments.toString();
    if(indexToUpdate==-1){
      OrderEvaluate evaluate = OrderEvaluate(recordId: bookListModel.recordId,rating: bookListModel.rating,comments: bookListModel.comments);
      orderEvaluates.add(evaluate);
    }
    return Container(
      margin:
          EdgeInsets.only(left: 10.w, top: 10.w, right: 10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8.w),
        color: const Color(0xFFF9F9F9),
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(3.w, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: ClipRRect(
        borderRadius: BorderRadius.circular(8.w),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            // 图书容器
            Container(
              color: Colours.cF8,
              padding: EdgeInsets.symmetric(horizontal: 11.w, vertical: 12.w),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    padding: EdgeInsets.all(2.w),
                    height: 88.w,
                    width: 73,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(4.w),
                      color: Colors.white,
                      boxShadow: [
                        BoxShadow(
                          color: const Color(0xFF707070).withOpacity(0.5),
                          offset: const Offset(0, 0),
                          blurRadius: 4.5.w,
                          spreadRadius: 0.w,
                        ),
                      ],
                    ),
                    child: Image.network(
                      // 'http://zxts-book-file.zijingebook.com/2024-01/29/b91194564969b9151fa382807977282acdffa22d.jpg',
                      bookListModel.img.toString(),
                      // 用实际图片链接替换
                      fit: BoxFit.cover,
                    ),
                  ),
                  Gaps.hGaps10,
                  Expanded(
                    child: Text(
                      bookListModel.name.toString(),
                      style: TextStyle(
                          fontSize: 13.w,
                          height: 1.5,
                          fontWeight: Fonts.boldSemi,
                          color: Colours.c3),
                      maxLines: 2,
                      overflow: TextOverflow.ellipsis,
                    ),
                  ),
                ],
              ),
            ),
            // 评价容器
            Container(
              padding: EdgeInsets.only(
                top: 1.w,
              ),
              width: double.infinity,
              height: 160.w,
              color: Colors.white,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  SizedBox(height:15.w),
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Container(
                        padding: EdgeInsets.only(left: 10.w),
                        child: const Text('评分'),
                      ),
                      Gaps.hGaps20,
                      AbsorbPointer(
                        absorbing: false,
                        child: CustomRating(
                          max: 5,
                            score:bookListModel.rating !=null ?bookListModel.rating!.toDouble():0,
                          star: Star(
                            fat: 0.5,
                            progress: 3,
                            fillColor: AppTheme.primary,
                            size: 16.w,
                            emptyColor: Colours.cE2,
                          ),
                          onRating: (double) {
                            orderEvaluates[index].rating=double;
                            myController.setCanClick(double: double);
                            print(double);
                          },
                        ),
                      ),
                    ],
                  ),
                  TextField(
                    controller: myController.commentsInput,
                    style:
                    TextStyle(fontSize: 14.w, color: Colours.c3),
                    decoration: InputDecoration(
                        focusedBorder: InputBorder.none,
                        border: InputBorder.none,
                        enabledBorder: InputBorder.none,
                        errorBorder: InputBorder.none,
                        fillColor: Colors.white,
                        hintText: '请简要描述',
                        hintStyle: TextStyle(
                            fontSize: 14.w, height: 1.5, color: Colours.c6)),
                      maxLines: 5,
                    onChanged: (text){
                      myController.setCanClick();
                      orderEvaluates[index].comments=myController.commentsInput.text;
                    },
                    focusNode: myController._focusNode,
                    // onTap: () {
                    //   // 在文本框获取焦点时，将光标移动到文本末尾
                    //   myController.commentsInput.selection = TextSelection.fromPosition(
                    //     TextPosition(offset: myController.commentsInput.text.length),
                    //   );
                    // },
                  ),


                  // CustomInputCommands(
                  //   decoration: InputDecoration(
                  //       focusedBorder: InputBorder.none,
                  //       border: InputBorder.none,
                  //       enabledBorder: InputBorder.none,
                  //       errorBorder: InputBorder.none,
                  //       fillColor: Colors.white,
                  //       hintStyle: TextStyle(
                  //           fontSize: 14.w, height: 1.5, color: Colours.c6)),
                  //   maxLines: 5,
                  //   controller: myController.commentsInput,
                  //   hintText: '请简要描述',
                  //    onChanged: (text){
                  //      myController.setCanClick();
                  //      print(myController.commentsInput.text);
                  //      orderEvaluates[index].comments=myController.commentsInput.text;
                  //    },
                  //    focusNode: myController._focusNode,
                  // ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  @override
  bool get wantKeepAlive => true;
}
