part of user_discuss_des;

class UserDiscussDesController extends GetxController {
  final String tag;
  final CourseModel model;
  UserDiscussDesController(this.tag,this.model);
  List<DiscussModel> discuss = [];

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );
  late TextEditingController replyInput = TextEditingController();

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;

  // 展示回复输入框
  bool showReply = false;
  // 当前要回复的模型
  late DiscussModel discussModel;
  // 当前要回复父级的模型
  late DiscussModel fatherDiscussModel;


  @override
  void onReady() {
    // onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    refreshController.dispose();
    replyInput.dispose();
    super.onClose();
  }

  void setShow() {
    showReply = !showReply;
    update();
  }
  void setDiscussModel(DiscussModel model){
    discussModel = model;
  }
  void setFatherDiscussModel(DiscussModel model){
    fatherDiscussModel = model;
  }

  // 删除回复
  Future<void> delComment({required DiscussModel discussModel}) async {
    final result = await LibraryAPI.delComment(bookId:model.bookId!, commentId: discussModel.id!);
    if(result){
      discuss.remove(discussModel);
      Toast.show('删除成功');
    }
    update();
  }

  Future<bool> submit() async {

    Map<String,dynamic> contentMap = {
      'text':replyInput.text,
      'audio':[],
      'image':[]
    };

    final result = await LibraryAPI.addDiscuss(
        bookId: model.bookId.toString(),
        chapterId: discussModel.chapterId.toString(),
        commentId: discussModel.id.toString(),
        quoteContent: '',
        title: '',
        content: jsonEncode(contentMap)
    );

    if(result){
      Toast.show('发表成功');
      discussModel.replyNum = discussModel.replyNum! +1;
      DiscussModel tempModel = DiscussModel.fromJson(discussModel.toJson());
      tempModel.status = 1;
      tempModel.commentsCheck = 0;
      tempModel.isMy = 1;

      NoteContentModel contentModel = NoteContentModel(
        text: MediaModel(content:replyInput.text,privacyStatus: 1)
      );
      tempModel.content= contentModel;
      tempModel.content?.text?.privacyStatus = 1;
      tempModel.replacePersonName = discussModel.personName;

      Map<String,dynamic> map = jsonDecode(StorageService.to.getString(kLocalUserInfo));
      if (map.keys.contains('head_img')){
        tempModel.personPic = map['head_img'];
      }
      if (map.keys.contains('name')){
        tempModel.personName = map['name'];
      }
      tempModel.replyNum = 0;
      fatherDiscussModel.commentAll?.add(tempModel);
      // fatherDiscussModel.replyNum = fatherDiscussModel.commentAll?.length;

    }
    else{
      Toast.show('发表失败');
    }
    replyInput.text = '';

    update();
    // 重置所有信息
    // reset();
    // setShowChat(false);
    return result;
  }


  Future<void> commentLove({required DiscussModel discussModel}) async {
    num type = 0;
    if (discussModel.isPraise ==0){
      type = 1;
    }
    final result = await LibraryAPI.commentLove(bookId:model.bookId! , type: type, commentId: discussModel.id!);
    if(result){
      num goodNum = discussModel.goodNum??0;
      if(type ==0){
        goodNum --;
      }
      else{
        goodNum ++;
      }
      discussModel.isPraise = type;
      discussModel.goodNum = goodNum;
    }
    update();
  }

  /// 获取讨论详情
  Future<void> _getDiscuss([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await MineAPI.discussList(
        page: _page,
        limit: _limit,
        bookId: model.bookId.toString(),
        types: tag
    );
    // 如果是刷新 清理数据
    if (isRefresh) discuss.clear();
    discuss.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getDiscuss(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      Console.log('------------onRefresh-----------------$error');
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getDiscuss();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }



}