part of apis;

abstract class CommonAPI {

  /// 1、广告位接口
  ///
  static Future <List<AdModel>> list({
    required String type,
  }) async {
    final result = await HttpService.to.post(
      '/v1/ad/ad/getListAll',
      params: {
        'type': type,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return AdModel.fromJson(result.data['list'][index]);
    });
  }

  /// 2、消息接口
  ///
  static Future <List<MsgModel>> msgs({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/message/Message/getList',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return MsgModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、消息未读数
  ///
  static Future <int> num() async {
    final result = await HttpService.to.post(
      '/v1/message/Message/getMessageNums',
      params: {},
    );
    if (result.data is! Map ) return 0;
    return result.data['num'];
  }

  /// 4、最近学习
  ///
  static Future <List<StudyHistoryModel>> history({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myReadRecord',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return StudyHistoryModel.fromJson(result.data['list'][index]);
    });
  }

  /// 5、消息未读变已读
  ///
  static Future <bool> read({
    required String id
  }) async {
    final result = await HttpService.to.post(
      '/v1/message/Message/editOneStatus',
      params: {
        'id':id
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 6、清除搜索记录
  ///
  static Future <bool> clear() async {
    final result = await HttpService.to.post(
      '/v1/book/Information/serachDel',
      params: {},
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 7、搜索历史记录
  ///
  static Future <List<String>> searchRecords() async {
    final result = await HttpService.to.post(
      '/v1/book/Information/serachRecord',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return result.data['list'][index]['name'];
    });
  }

  /// 8、搜索书籍
  ///
  static Future <List<CourseModel>> searchBooks({
    int page = 1,
    int limit = 20,
    required String keyWord
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/searchBook',
      params: {
        'page': page,
        'page_size': limit,
        'keyword':keyWord
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 9、收藏 取消收藏
  ///
  static Future <bool> love({
    required String  bookId,
    required String love
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/collection',
      params: {
        'book_id':bookId,
        'is_select':love
      },
    );
    if (result.data is! Map || result.data['is_success'] == 0){
      return false;
    }
    return true;
  }

  /// 10、上传文件
  static Future <String> upload({
    required String path
  }) async {
    final result = await HttpService.to.upload(
        '/v1/members/Information/uploadFile',
        path: path
    );
    if (result.data is! Map) return '';
    return result.data['filesUrl'];
  }

  /// 11、创建订单
  ///
  static Future <PayOrderModel> createOrder({
    required String bookIdsList,
    required String totalPrice,
    required String couponRecId,
    required String integral,
    required String type

  }) async {
    final result = await HttpService.to.post(
      '/v1/orders/Orders/createOrders',
      params: {
        'book_ids_list':bookIdsList,
        'total_price':totalPrice,
        'coupon_rec_id':couponRecId,
        'integral':integral,
        'type':type,
      },
    );
    if (result.data is! Map) return PayOrderModel();
    return PayOrderModel.fromJson(result.data);
  }


}