part of user_love;

class BuildItem extends StatelessWidget {
  final CourseModel model;
  final void Function()? onTap;
  const BuildItem({
    Key? key,
    required this.model,
    this.onTap
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(left: 10,top: 15,bottom: 15),
      margin: const EdgeInsets.only(top:15,left: 10,right: 10),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(8),
        boxShadow: [
          BoxShadow(
            color: Colours.cC7.withOpacity(0.5), // 阴影颜色
            spreadRadius: 2, // 阴影扩散半径
            blurRadius: 5, // 阴影模糊半径
            offset: const Offset(0, 2), // 阴影偏移
          ),
        ],

      ),
      // height: 200,
      // color: Colors.cyanAccent,
      child: Row(
        children: [
          /// 左侧
          CustomCard(
            width: 72,
            height: 86,
            url: model.img??'',
          ),
          /// 右侧
          Expanded(
            child: Container(
              margin: const EdgeInsets.only(left: 10,right: 10),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(model.bookName??'',overflow: TextOverflow.ellipsis,maxLines: 1,style: const TextStyle(fontSize: 14,fontWeight: Fonts.medium,height: 1.5,color: Colours.c3),),
                  const SizedBox(height: 4,),
                  Text(model.authors??'',style: const TextStyle(fontSize: 12,color: Colours.c9,height: 1.5),),
                  Gaps.vGaps15,
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      const SizedBox(),
                      GestureDetector(
                        onTap: onTap,
                        child: Container(
                          padding: const EdgeInsets.only(top: 10),
                          width: 30,
                          height: 30,
                          // color: Colors.yellow,
                          child: Image.asset(
                            'assets/images/del.png',
                          ),
                        ),
                      )
                    ],
                  )
                ],
              ),
            ),
          )
        ],
      ),
    );
  }
}
