part of book_detail;

class BuildBook extends StatelessWidget {
  final BookDetailModel model;

  const BuildBook({Key? key, required this.model}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
        // decoration: const BoxDecoration(
        //     // color: Colors.red,
        //     gradient: LinearGradient(
        //       colors: [Color(0xFFF7F5F5),Color(0xFFFFFFFF)],
        //       begin: Alignment.topCenter,
        //       end: Alignment.bottomCenter,
        //     ),
        // ),
        // margin: const EdgeInsets.only(left: 10,right: 10,top: 10),

        width: double.infinity,
        height: 150,
        color: const Color(0xFFAB1941).withOpacity(0.02),
        child: Row(
          children: [
            ///左侧
            Container(
              margin: EdgeInsets.only(left: 15.w, right: 15.w),
              child: Row(
                children: [
                  CustomCard(
                    url: model.img ?? '',
                    height: 110.w,
                    width: 100.w,
                  )
                ],
              ),
            ),

            ///右侧
            Expanded(
              child: Container(
                // color: Colors.cyan,
                padding: EdgeInsets.only(top: 12.w, bottom: 15.w),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          model.bookName ?? '',
                          style: TextStyle(
                              fontSize: 17.w,
                              fontWeight: Fonts.medium,
                              color: Colours.c3),
                          maxLines: 1,
                          overflow: TextOverflow.ellipsis,
                        ),
                        SizedBox(
                          height: 5.w,
                        ),
                        Text(model.authors ?? '',
                            style: TextStyle(
                                fontSize: 14.w,
                                fontWeight: FontWeight.w400,
                                color: Colours.c6)),
                      ],
                    ),
                    Row(
                      children: [
                        Text('￥${model.vipPrice}',
                            style: TextStyle(
                                fontSize: 15.w,
                                fontWeight: FontWeight.w500,
                                color: AppTheme.primary)),
                        Gaps.hGaps10,
                        Text('￥${model.price}',
                            style: TextStyle(
                                fontSize: 13.w,
                                color: Colours.c9,
                                decoration: TextDecoration.lineThrough,
                                decorationColor: Colours.c9,
                                // 可选，指定删除线的颜色
                                decorationThickness: 1)),
                      ],
                    )
                  ],
                ),
              ),
            )
          ],
        ));
  }
}
