part of library;

class LibraryPage extends StatefulWidget {
  const LibraryPage({Key? key}) : super(key: key);

  @override
  State<LibraryPage> createState() => _LibraryPageState();
}

class _LibraryPageState extends State<LibraryPage>  {

  @override
  Widget build(BuildContext context) {
    return GetBuilder<LibraryController>(
      init: LibraryController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            title: const Text('图书馆'),
            actions: [
              IconButton(
                icon: Image.asset('assets/images/search.png'),
                tooltip: 'Open shopping cart',
                onPressed: () {
                  context.pushNamed(Routes.search);
                },
              ),
            ],
          ),
          body: _buildBody(controller)
        ),
    );
  }

  Widget _buildBody(LibraryController controller){
    return Stack(
      children: [
        Column(
          mainAxisSize: MainAxisSize.max,
          children: [
            // _buildTab(controller),
            Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Expanded(child: _buildCategory()),
                GestureDetector(
                  onTap: (){
                    controller.setShow(controller.show);
                  },
                  child: Container(
                    padding: EdgeInsets.only(left: 10.w,right: 10.w,top: 3.w),
                    alignment: Alignment.center,
                    height: 38.w,
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Container(
                          width: 15.w,
                          height: 15.w,
                          // color: Colors.red,
                          alignment: Alignment.center,
                          child: Image.asset(
                            'assets/images/filter.png',
                            fit: BoxFit.cover,
                            width: 15.w,
                            height: 15.w,
                          ),
                        ),
                        Gaps.hGaps5,
                        Text('筛选',style: TextStyle(color: Colours.c9,fontSize: 14.w,height: 1.5),)
                      ],
                    ),
                    // width: 75,
                  ),
                )
              ],
            ),
            _buildLabel(),
            Container(
              // color: Colors.red,
              child: Expanded(
                child: CustomPullScrollView(
                  controller: controller.refreshController,
                  onRefresh: controller.onRefresh,
                  onLoading: controller.onLoading,
                  child: SingleChildScrollView(
                    child: Column(
                      mainAxisSize: MainAxisSize.max,
                      children: [
                        controller.ads.isNotEmpty?Container(
                            color: Colors.transparent,
                            padding: EdgeInsets.symmetric(horizontal: 10.w),
                            child: BuildBanner(
                              items:controller.ads,
                              onTap:(adModel){
                                context.pushNamed(Routes.adDetail,extra: adModel);
                              } ,
                            )
                        ):const SizedBox(),

                        LibraryContentPage(controller: controller,)
                      ],
                    ),
                  ),
                ),
              ),
            )
          ],
        ),
        Visibility(
          visible: controller.show,
          child: FilterPage(
            controller: controller,
            sureTap: (){
              controller.setShow(controller.show);
            },
            resetTap: (){

            },),
        ),
      ],
    );
  }

  Widget _buildLabel(){
    return Container(
      height: 43.w,
      color: Colours.cF9,
      child: GetBuilder<LibraryController>(
        init: LibraryController(),
        // id: 'label',
        builder:(controller) =>ListView.builder(
          scrollDirection:Axis.horizontal ,
          itemBuilder: (BuildContext context, int index){
            return GestureDetector(
              child: BuildLabelWidget(model: controller.filterLabels[index],),
              onTap: (){
                controller.selectLabel( controller.filterLabels[index]);
              },
            );
          },
          itemCount: controller.filterLabels.length,
        ),
      ),
    );
  }

  Widget _buildCategory(){
    return Container(
      height: 38.w,
      child: GetBuilder<LibraryController>(
        init: LibraryController(),
        builder: (controller) =>ListView.builder(
          scrollDirection: Axis.horizontal,
          itemBuilder: (BuildContext context, int index){
            FilterModel model = controller.filterCategories[index];
            return GestureDetector(
              onTap: (){
                controller.selectCategory(model);
              },
              child: Container(
                padding: EdgeInsets.symmetric(vertical: 10.w,horizontal: 10.w),
                color: model.selected?const Color(0xFFC02D55).withOpacity(0.08):Colors.white,
                alignment: Alignment.center,
                child: Text(model.name??'',style: model.selected?TextStyle(fontSize: 14.w,color: AppTheme.primary,fontWeight: Fonts.boldSemi,):TextStyle(fontSize: 14.w,color: Colours.c9,),),
              ),
            );
          },
          itemCount: controller.filterCategories.length
        )
      ),
    );
  }


  PreferredSizeWidget _buildTab(LibraryController controller){
    return PreferredSize(
      preferredSize: Size.fromHeight(48.w),
      child: Container(
        color: Colors.white,
        child: Row(
          children: [
            // TabBar放在左侧
            Expanded(
              child: TabBar(
                indicator: BoxDecoration(
                    border: const Border(bottom: BorderSide(color: Colors.transparent, width: 0.0)), // 将指示器的底边框颜色设置为透明
                    color: const Color(0xFFC02D55).withOpacity(0.08)
                ),
                labelStyle: TextStyle(color: AppTheme.primary,fontSize: 14.w,height: 1.5,fontWeight: Fonts.medium),
                unselectedLabelColor: Colours.c9,
                unselectedLabelStyle:  TextStyle(color: Colours.c9,fontSize: 14.w,height: 1.5),
                controller: controller.tabController,
                isScrollable: true,
                tabs: controller.filterCategories.map((model){
                  return Tab(text: model.name);
                }).toList(),
              ),
            ),
            // 筛选按钮放在右侧
            GestureDetector(
              onTap: (){
                controller.setShow(controller.show);
              },
              child: Container(
                padding: EdgeInsets.symmetric(horizontal: 10.w),
                alignment: Alignment.center,
                height: 38.w,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      width: 12.w,
                      height: 12.w,
                      // color: Colors.red,
                      alignment: Alignment.center,
                      child: Image.asset(
                        'assets/images/filter.png',
                      ),
                    ),
                    Gaps.hGaps5,
                    Text('筛选',style: TextStyle(color: Colours.c9,fontSize: 14.w,height: 1.5),)
                  ],
                ),
                // width: 75,
              ),
            )
          ],
        ),
      ),
    );
  }
  // @override
  // bool get wantKeepAlive => true;
}
