part of user_order;

class OrderSearchPage extends StatefulWidget {
  const OrderSearchPage({Key? key}) : super(key: key);

  @override
  State<OrderSearchPage> createState() => _SearchPageState();
}

class _SearchPageState extends State<OrderSearchPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserSearchController>(
      init: UserSearchController(),
      builder: (controller) => Scaffold(
        appBar: CustomAppBar(
          automaticallyImplyLeading: false,
          titleSpacing: 0,
          title: Padding(
            padding: EdgeInsets.symmetric(horizontal: AppTheme.margin),
            child: CustomInputSearch(
              controller: controller.searchController,
              readOnly: false,
              hintText: '搜索图书名称/订单编号',
              onTap: () {
                // context.pushNamed(Routes.msgs);
              },
              onEditingComplete: () {
                controller._getOrders(
                    isRefresh: true,
                    keys: controller.searchController.text,);
                // FocusScope.of(context).unfocus();
                FocusNode blankNode = FocusNode();
                FocusScope.of(context).requestFocus(blankNode); //指定为空白焦点
              },
            ),
          ),
          actions: [
            GestureDetector(
              onTap: () {
                context.pop();
              },
              child: Container(
                padding: EdgeInsets.only(left: 10.w, top: 10.w, bottom: 10.w),
                child: Text(
                  '取消',
                  style:
                      TextStyle(fontSize: 14.w, height: 1.5, color: Colours.c3),
                ),
              ),
            )
          ],
        ),
        body:  ListView.builder(
          itemBuilder: (BuildContext context, int index) {
            OrderListModel model = controller.orderList[index];
            // OrderListModel model = widget.models[index];
            if (model.types == 2) {
              return BuiltCoin(model: model,);
            } else {
              if (model.status == 1) {
                return BuiltAwaiting(model: model,);
              } else if (model.status == 2) {
                return BuiltCanceled(model: model,);
              } else if (model.status == 3) {
                return BuiltCompleted(model: model,);
              } else if (model.status == 4) {
                return BuiltRefunded(model: model,);
              }
            }
          },
          itemCount: controller.orderList.length,
          // itemCount: widget.models.length,
        ),
      ),
    );
  }
}
