part of user_notes;

class UserNotePage extends StatefulWidget {
  const UserNotePage({Key? key}) : super(key: key);

  @override
  State<UserNotePage> createState() => _UserNotePageState();
}

class _UserNotePageState extends State<UserNotePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserNoteController>(
      init: UserNoteController(),
      builder:(controller)=> Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('笔记'),
        ),
        body: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Container(
                margin: EdgeInsets.only(left: 22.5.w,top: 16.w),
                child: Text('共${controller.notes.length}本书',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c6,fontWeight: Fonts.medium),)
            ),
            Expanded(
              child: CustomPullScrollView(
                  controller: controller.refreshController,
                  onRefresh: controller.onRefresh,
                  onLoading: controller.onLoading,
                  child:ListView.builder(
                    // physics: const NeverScrollableScrollPhysics(),
                    // shrinkWrap: true,
                    itemBuilder: (BuildContext context, int index){
                      return GestureDetector(
                        onTap: (){
                          context.pushNamed(Routes.noteDes,extra: controller.notes[index]);
                        },
                          child: BuildItem(model: controller.notes[index],)
                      );
                    },
                    itemCount: controller.notes.length,
                  )
              ),
            ),
          ],
        ),
      ),
    );
  }
}
