part of help_cneter_content;

/// 帮助中心-常见问题-内容详情
class HelpCenterContentPage extends StatefulWidget {
  final String id;

  const HelpCenterContentPage({
    Key? key,
    required this.id,
  }) : super(key: key);

  @override
  State<HelpCenterContentPage> createState() => _HelpCenterContentPageState();
}

class _HelpCenterContentPageState extends State<HelpCenterContentPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<HelpCenterContentController>(
        init: HelpCenterContentController(widget.id),
        builder: (controller) => Scaffold(
              appBar: AppBar(
                centerTitle: true,
                title: const Text('常见问题'),
              ),
              body: Container(
                width: double.infinity,
                margin: EdgeInsets.only(
                    left: 15.w, top: 10.w, right: 15.w, bottom: 15.w),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start, // 下面的Text靠左
                  children: [
                    Align(
                      alignment: Alignment.topCenter,
                      child: Text(
                        controller.helpCenterContentModel.helpTitle ?? '',
                        style: TextStyle(
                            fontSize: 16.w, height: 1.5.w, color: Colours.c3),
                      ),
                    ),
                    SizedBox(height: 15.w), // 添加15dp的间隔,
                    Text(
                      controller.helpCenterContentModel.helpContent ?? '',
                      style: TextStyle(
                          fontSize: 14.w, height: 1.5.w, color: Colours.c3),
                    ),
                  ],
                ),
              ),
            ));
  }
}

/*@override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('常见问题'),
      ),
      body: Container(
        margin: EdgeInsets.all(15.w),
        child: Column(
          children: [
            Text(
              model.helpTitle ?? '',
              style: TextStyle(fontSize: 16.w, height: 1.5, color: Colours.c3),
            ),
            Text(
              model.helpContent ?? '',
              style: TextStyle(fontSize: 14.w, height: 1.5, color: Colours.c3),
            ),
          ],
        ),
      ),
    );
  }*/
