part of user_notes_des;

class BuildNote extends StatelessWidget {
  final NoteModel model;
  const BuildNote({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 10.w,right: 10.w,top: 10.w),
      padding: EdgeInsets.all(10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4.w),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(1.5.w, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text('看来谁都不记得自己为何出现在此',style: TextStyle(
            fontSize: 14.w,
            height: 1.5,
            // color: Colors.red,
            color:Colours.c3
          ),),
          Gaps.vGaps13,
          _buildImageGridView(),
          Gaps.vGaps13,
          _buildAudioListView(),
          Gaps.vGaps13,
          Container(
            width: double.infinity,
            padding: EdgeInsets.symmetric(vertical: 5.w,horizontal: 10.w),
            color: Colours.cF8,
            child:Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(model.chapterName??'',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                Text('内容：${model.content??''}',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
              ],
            )
          )
        ],
      ),
    );
  }

  // 图片
  Widget _buildImageGridView(){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 6,
          crossAxisSpacing: 2.w,
          mainAxisSpacing: 2.w,
          childAspectRatio: 1
      ),
      itemBuilder: (BuildContext context, int index) {
        return Container(
          color: Colors.red,
          child: Center(child: Text('图片')),
        );
      },
      itemCount: 3,
    );
  }

  Widget _buildAudioListView(){
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      itemBuilder: (BuildContext context, int index) {
        return Container(
          height: 20.w,
          margin: EdgeInsets.only(right: 130.w),
          child: Container(
            margin: EdgeInsets.only(top: 5.w),
            padding: EdgeInsets.only(right:20.w,left: 10.w),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10.w),
              color: Colours.cF9,
            ),
            child: Row(
              // mainAxisSize: MainAxisSize.min,
              mainAxisAlignment:MainAxisAlignment.spaceBetween,
              children: [
                Image.asset('assets/images/audio.png'),
                Text('0:00/1:52',style: TextStyle(fontSize: 10.w,height: 1.4,color: Colours.c9),)
              ],
            ),
          ),
        );
      },
      itemCount: 3,
    );
  }
  // Widget _buildAudioGridView(){
  //   return GridView.builder(
  //     physics: const NeverScrollableScrollPhysics(),
  //     shrinkWrap: true,
  //     gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
  //         crossAxisCount: 6,
  //         crossAxisSpacing: 2.w,
  //         mainAxisSpacing: 2.w,
  //         childAspectRatio: 1
  //     ),
  //     itemBuilder: (BuildContext context, int index) {
  //       return Container(
  //         color: Colors.red,
  //         child: Center(child: Text('音频')),
  //       );
  //     },
  //     itemCount: 3,
  //   );
  // }

}
