part of user_order;
/// 紫荆币item
class BuiltCoin extends StatelessWidget {
  final OrderListModel model;
  final UserOrderController controller;
  const BuiltCoin({Key? key, required this.model,required this.controller}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    String status = '已完成';
    if(model.status==1){
      status ='待支付';
    }else if(model.status==2){
      status ='已取消';
    }else if(model.status==3){
      status ='已完成';
    }
    return GestureDetector(
      onTap: () async {
        if(model.status == 1){
          final result = await context.pushNamed(Routes.orderCoinAwaiting,
                queryParameters: {'orderNum': model.ordersnum});
          if(result==true){
            controller.onRefresh();
          }
        }
        else if(model.status == 2){
          final result = await context.pushNamed(Routes.orderCoinCancel,
              queryParameters: {'orderNum': model.ordersnum});
          if(result==true){
            controller.onRefresh();
          }
        }
        else if(model.status == 3){
          final result = await context.pushNamed(Routes.orderCoinCompleted,
              queryParameters: {'orderNum': model.ordersnum});
          if(result==true){
            controller.onRefresh();
          }
        }
      },
      child: Container(
        margin: EdgeInsets.only(left: 10.w, right: 10.w, top: 10.w),
        padding: EdgeInsets.only(left: 11.5.w),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(8.w),
          color: Colors.white,
          boxShadow: [
            BoxShadow(
              color: const Color(0xFFC7C7C7).withOpacity(0.5),
              offset: Offset(1.5.w, 0),
              blurRadius: 7.w,
              spreadRadius: 0.w,
            ),
          ],
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Container(
              margin: EdgeInsets.only(top: 19.w, bottom: 19.w, right: 16.5.w),
              child: Image.asset(
                'assets/images/coin.png',
                height: 30.w,
                width: 30.w,
                fit: BoxFit.cover,
              ),
            ),
            Expanded(
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        SizedBox(
                          height: 12.w,
                        ),
                        Text(
                          model.createTime.toString(),
                          style: TextStyle(fontSize: 12.w, color: Colours.c9),
                        ),
                        SizedBox(
                          height: 10.w,
                        ),
                        Text(
                          '充值紫荆币',
                          style: TextStyle(
                              fontSize: 13.w,
                              color: Colours.c3,
                              fontWeight: Fonts.medium),
                        )
                      ],
                    ),
                    Container(
                      margin: EdgeInsets.only(right: 1.w),
                      child:  Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        children: [
                          SizedBox(
                            height: 4.5.w,
                          ),
                          model.status == 1?Align(
                            alignment: Alignment.topRight,
                            child: Container(
                              margin: EdgeInsets.only( right: 4.w),
                              width: 110,
                              height: 20,
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  // 左半部分的文字
                                  Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.only(
                                          topLeft: Radius.circular(180.w),
                                          bottomLeft: Radius.circular(180.w)),
                                      color: Colours.cC31F4C,
                                    ),
                                    height: double.infinity,
                                    width: 55,
                                    child: Align(
                                      alignment: Alignment.center,
                                      child: Text(
                                        '等待付款',
                                        style: TextStyle(
                                          color: Colors.white,
                                          fontSize: 10.w,
                                          fontWeight: Fonts.medium,
                                        ),
                                      ),
                                    ),
                                  ),

                                  // 右半部分的文字
                                  Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.only(
                                          topRight: Radius.circular(180.w),
                                          bottomRight: Radius.circular(180.w)),
                                      color: Colours.cC31F4C2,
                                    ),
                                    height: double.infinity,
                                    width: 55,
                                    child: Align(
                                      alignment: Alignment.center,
                                      child: Text(
                                        '${(30 - (DateTime.now().difference(DateTime.parse(model.createTime.toString()))).inMinutes)==0?
                                        1:30 - (DateTime.now().difference(DateTime.parse(model.createTime.toString()))).inMinutes}分钟',
                                        style: TextStyle(
                                            color: Colours.cC31F4C,
                                            fontSize: 10.w,
                                            fontWeight: Fonts.medium),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ):Container(
                            margin: EdgeInsets.only(right: 10.w,top: 10.w),
                              child: Text(status, style: TextStyle(fontSize: 13.w, color: Colours.c9),)),
                          SizedBox(height: 6.5.w,),
                          Container(
                            margin: EdgeInsets.only(right: 10.w),
                            child: Text(
                              '¥${model.finalTotalPrice}',
                              style: TextStyle(
                                  fontSize: 14.w,
                                  color: Colours.cAB1941,
                                  fontWeight: Fonts.medium),
                            ),
                          )
                        ],
                      ),
                    ),

                  ],
                )),
          ],
        ),
      ),
    );
  }
}
