part of reset_pwd;

class ResetPwdPage extends StatefulWidget {
  final String phone;
  final String code;
  const ResetPwdPage({
    Key? key ,
    required this.phone,
    required this.code,
  }) : super(key: key);
  // const ResetPwdPage({Key? key}) : super(key: key);

  @override
  State<ResetPwdPage> createState() => _ResetPwdPageState();
}

class _ResetPwdPageState extends State<ResetPwdPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ResetPwdController>(
      init: ResetPwdController(phone: widget.phone, code: widget.code),
      builder: (controller) =>Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('重置密码'),
        ),
        body: Container(
          margin: const EdgeInsets.only(left: 10,top: 15,right: 10),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              ValueListenableBuilder<bool>(
                valueListenable: controller.showPassword,
                builder:(context, value, child) => CustomFormInput(
                  obscureText: !value,
                  hintText: '请输入新密码',
                  iconData:
                  value ? Image.asset(
                    'assets/images/eye_open.png',
                  )  : Image.asset(
                    'assets/images/eye_close.png',
                  ),
                  controller: controller.pwdInput,
                  onChanged: (text){
                    controller.setCanClick();
                  },
                  onIcon: controller.onShowPassword,
                ),
              ),
              Gaps.vGaps10,
              ValueListenableBuilder<bool>(
                valueListenable: controller.showPassword2,
                builder:(context, value, child) => CustomFormInput(
                  obscureText: !value,
                  hintText: '请再次输入密码',
                  iconData:
                  value ? Image.asset(
                    'assets/images/eye_open.png',
                  )  : Image.asset(
                    'assets/images/eye_close.png',
                  ),
                  controller: controller.pwd2Input,
                  onChanged: (text){
                    controller.setCanClick();
                  },
                  onIcon: controller.onShowPassword2,
                ),
              ),
              Container(
                margin: const EdgeInsets.only(left: 5,top: 5),
                child: const Text('密码必须是6-20个英文字母、数字或符号',style: TextStyle(fontSize: 10,color: Colours.c9),),
              ),
              Gaps.vGaps40,
              CustomGradientButton(
                text: '确认修改',
                isEnabled: controller.enable,
                onPressed: () {
                  controller.resetPassword(context);
                  // context.goNamed(Routes.login);
                },
              )
            ],
          ),
        ),
      ),
    );
  }
}
