part of library;

class FilterPage extends StatefulWidget {
  final LibraryController controller;
  final void Function() sureTap;
  final void Function() resetTap;
  const FilterPage({
    Key? key,
    required this.sureTap,
    required this.resetTap,
    required this.controller
  }) : super(key: key);

  @override
  State<FilterPage> createState() => _FilterPageState();
}

class _FilterPageState extends State<FilterPage> {
  @override
  Widget build(BuildContext context) {
    // List<FilterModel> categories = widget.controller.categories.map((model) {
    //   return FilterModel(id: model.categoryId.toString(), name: model.name??'');
    // }).toList();
    //
    // List<FilterModel> labels = widget.controller.labels.map((model) {
    //   return FilterModel(id: model.labelId.toString(), name: model.name??'');
    // }).toList();

    return Container(
      color: const Color(0xFF000000).withOpacity(0.5),
      child: SingleChildScrollView(
        child: Column(
          children: [
            Container(
              color: Colors.white,
              width: double.infinity,
              padding: EdgeInsets.only(bottom: 10.w),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      _buildWrapWidget('分类', widget.controller.filterCategories),
                      _buildWrapWidget('标签', widget.controller.filterLabels),
                      _buildWrapWidget('是否收费', widget.controller.filterFree),
                      _buildWrapWidget('排序', widget.controller.filterDown),
                    ],
                  )
                ],
              ),

            ),
            Container(
              padding: EdgeInsets.only(left:10.w,right:10.w,top:30.w,bottom:10.w),
              color: Colors.white,
              // margin: const EdgeInsets.symmetric(horizontal: 15),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                children: [
                  Expanded(
                    child: GestureDetector(
                      onTap: (){
                        widget.controller.resetFilter();
                      },
                      child: Container(
                        alignment: Alignment.center,
                        height: 35.w,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(17.5.w),
                          border:Border.all(
                              width: 0.5.w,
                              color: Colours.c9
                          ),
                          // color: Colours.cE0.withOpacity(0.5),
                        ),
                        // padding: EdgeInsets.symmetric(vertical: 8),
                        child: Text('重置',style: TextStyle(fontSize: 13.w,color: Colours.c9,height: 1.5),),
                      ),
                    ),
                  ),
                  Gaps.hGaps10,
                  Expanded(
                    child: GestureDetector(
                      onTap: widget.sureTap,
                      child: Container(
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(17.5.w),
                            color: AppTheme.primary.withOpacity(0.1)
                        ),
                        height: 35.w,
                        alignment: Alignment.center,
                        padding: EdgeInsets.symmetric(vertical: 8.w),
                        child: Text('确定',style: TextStyle(fontSize: 13.w,color: AppTheme.primary,height: 1.5),),
                      ),
                    ),
                  )
                ],
              ),
            )
          ],
        ),
      ),
    );
  }

  Widget _buildWrapWidget(String title,List<FilterModel> data){
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
            margin: EdgeInsets.only(left: 10.w,bottom: 10.w,top: 10.w),
            child: Text(title,style: TextStyle(fontSize: 15.w,height:1.6,color: Colours.c3,fontWeight: Fonts.boldSemi),)
        ),
        Container(
          margin: EdgeInsets.only(left: 10.w),
          child: Wrap(
            spacing: 10,
            runSpacing: 10,
            alignment: WrapAlignment.start,
            runAlignment: WrapAlignment.start,
            children: data.map((model){
              return GestureDetector(
                onTap: (){
                  setState(() {
                    for (FilterModel model in data){
                      model.selected = false;
                    }
                    model.selected = !model.selected;
                    if (model.name == '读过' || model.name == '评分'){
                      if(model.selected){
                        model.up = !model.up;
                      }
                      else{
                        model.up = true;
                      }
                    }
                  });
                },
                child: Container(
                  height: 27,
                  padding:  const EdgeInsets.only(left: 15,right: 15),
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(13.5),
                      color: model.selected?const Color(0xFFC02D55).withOpacity(0.08): Colours.cF4,
                      border: model.selected?Border.all(width: 0.5.w,color: AppTheme.primary):null

                  ),
                  child:  model.name == '读过' || model.name == '评分'?Row(
                      mainAxisSize: MainAxisSize.min,
                      children: [
                        Text(model.name??'',style: TextStyle(fontSize: 13,height: 1.4,color: model.selected?AppTheme.primary: Colours.c3),textAlign: TextAlign.center,),
                        Image.asset(model.selected?model.up?'assets/images/filter_up.png':'assets/images/filter_down.png':'assets/images/filter_unselect.png'),
                      ],
                    ):Padding(padding: EdgeInsets.only(top: 4.w),child: Text(model.name??'',style: TextStyle(fontSize: 13,height: 1.4,color: model.selected?AppTheme.primary: Colours.c3),textAlign: TextAlign.end,),),


                ),
              );
            }).toList(),
          ),
        )
      ],
    );
  }
}
