part of book_pay;

class BuildPayWay extends StatelessWidget {
  final PayModel model;
  final BookPayController? controller;
  const BuildPayWay({
    Key? key,
    required this.model,
    this.controller
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Container(
          padding: EdgeInsets.symmetric(horizontal: 4.w),
          color: Colors.white,
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Row(
                children: [
                  Container(
                    margin: EdgeInsets.symmetric(vertical: 12.w),
                    // color: Colors.cyan,
                    width:20.w,
                    height:20.w,
                    child: Image.asset(model.icon),
                  ),
                  SizedBox(width: 7.w,),
                  Text(model.name,style: TextStyle(fontSize: 14.w,color: Colours.c3,height: 1.1)),
                ],
              ),
              Row(
                children: [
                  model.type == 3&& model.selected ?Text(controller !=null?controller!.noticeText:'',style: TextStyle(fontSize: 11.w,color: AppTheme.primary,height: 1.1)):const SizedBox(),
                  model.type == 3&& model.selected ?Gaps.hGaps10:const SizedBox(),
                  SizedBox(
                    // color: Colors.cyan,
                    width:15.w,
                    height:15.w,
                    child: Image.asset(model.selected?'assets/images/pay_check.png':'assets/images/pay_uncheck.png'),
                  )
                ],
              )
            ],
          ),
        ),
        Container(
          margin: EdgeInsets.symmetric(horizontal:10.w),
          height: 0.5,
          color: Colours.cF0,
        )
      ],
    );
  }
}
