part of apis;

abstract class AccountAPI {

  /// 登录
  static Future <UserModel> login({
    required String phone,
    required String type,
    String? password,
    String? code,
  }) async {
    // assert((password != null && code == null) ||
    //     (password == null && code != null),
    // 'Provide either a password or a verification code, not both.');

    Map<String,dynamic> params = {
      'phone' : phone,
      'type' : type,
    };

    // 密码登录
    if(type == '1'){
      params['password'] = password;
    }
    // 验证码登录
    if(type == '2'){
      params['code'] = code;
    }
    final result = await HttpService.to.post(
      '/v1/members/login/login',
      excludeToken: true,
      showLoading: true,
      params: params
    );
    print(result.data);
    if (result.data is! Map) return UserModel();
    return UserModel.fromJson(result.data);
  }

  /// 退出登录
  static Future logout() async{
    final result = await HttpService.to.post(
      '/v1/members/login/logout',
      params: {}
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 注销
  static Future delete() async{
    final result = await HttpService.to.post(
      '/v1/members/login/del',
      params: {}
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 发送验证码
  static Future sendCode({
    required String phone,
    required String type,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/login/sendCode',
      params: {
        'phone': phone,
        'types': type
      },
      excludeToken: true,
      showLoading: true,
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 重置密码
  static Future resetPassword({
    required String phone,
    required String code,
    required String password,
    required String rePassword,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/login/editPassword',
      params: {
        'phone': phone,
        'code': code,
        'password': password,
        'repassword': rePassword
      },
      excludeToken: true,
      showLoading: true,
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }





}