part of library;

class LibraryPage extends StatefulWidget {
  const LibraryPage({Key? key}) : super(key: key);

  @override
  State<LibraryPage> createState() => _LibraryPageState();
}

class _LibraryPageState extends State<LibraryPage> with AutomaticKeepAliveClientMixin,SingleTickerProviderStateMixin{


  @override
  Widget build(BuildContext context) {
    return GetBuilder<LibraryController>(
      init: LibraryController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            title: const Text('图书馆'),
            actions: [
              IconButton(
                icon: const Icon(Icons.search_rounded),
                tooltip: 'Open shopping cart',
                onPressed: () {
                  context.pushNamed(Routes.search);
                },
              ),
            ],
            bottom: PreferredSize(
              preferredSize: Size.fromHeight(38),
              child: Container(
                color: Colors.white,
                width: double.infinity,
                child: Container(
                  decoration: BoxDecoration(
                      border: Border.all(width: 0.5,color: Colours.cE5)
                  ),
                  child: Row(
                    children: [
                      Expanded(
                        child: TabBar(
                          indicator: BoxDecoration(
                              border: Border(bottom: BorderSide(color: Colors.transparent, width: 0.0)), // 将指示器的底边框颜色设置为透明
                              color: Color(0xFFC0D55).withOpacity(0.08)
                          ),
                          labelStyle: TextStyle(color: AppTheme.primary,fontSize: 14,height: 1.5,fontWeight: Fonts.medium),
                          unselectedLabelColor: Colours.c9,
                          unselectedLabelStyle: TextStyle(color: Colours.c9,fontSize: 14,height: 1.5),
                          controller: controller.tabController,
                          isScrollable: true,
                          tabs: [
                            Tab(text: '全部'),
                            Tab(text: '职业证书'),
                            Tab(text: '人文艺术'),
                            Tab(text: '财经管理'),
                            Tab(text: '待评价'),
                            Tab(text: '待评价1'),
                            Tab(text: '待评价2'),
                          ],
                        ),
                      ),
                      GestureDetector(
                        child: Container(
                          padding: const EdgeInsets.symmetric(horizontal: 10),
                          alignment: Alignment.center,
                          // color: Colors.cyan,
                          height: 38,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              Container(
                                width: 12,
                                height: 12,
                                // color: Colors.red,
                                alignment: Alignment.center,
                                child: Image.asset(
                                  'assets/images/filter.png',
                                ),
                              ),
                              Gaps.hGaps5,
                              const Text('筛选',style: TextStyle(color: Colours.c9,fontSize: 14,height: 1.5),)
                            ],
                          ),
                          // width: 75,
                        ),
                      )
                    ],
                  ),
                ),
              ),
            ),
          ),

          body: TabBarView(
            controller: controller.tabController,
            children: List.generate(7, (index){
              return LibraryContentPage();
            })
          ),
        ),
    );
  }

  /// 列表
  Widget createListView(){
    return ListView.builder(
      itemBuilder: (BuildContext context, int index){
        return LibraryCell();
      },
      itemCount: 2,
    );
  }

  @override
  // TODO: implement wantKeepAlive
  bool get wantKeepAlive => true;
}
