part of scale_image;


class ScaleImagePage extends StatefulWidget {
  final Map<String,String> params;
  const ScaleImagePage({
    Key? key,
    required this.params
  }) : super(key: key);

  @override
  State<ScaleImagePage> createState() => _ScaleImagePageState();
}

class _ScaleImagePageState extends State<ScaleImagePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: Text('${widget.params['title']}'),
        ),
        body: InAppWebView(
          initialUrlRequest: URLRequest(
              url: WebUri.uri(Uri.parse(kScaleImage))
          ),
          onLoadStop: (controller, url) {
            String jsonStr = jsonEncode(widget.params);
            controller.evaluateJavascript(source: 'callbackInFlutterComponent($jsonStr)');
          },
          onConsoleMessage: (controller, consoleMessage) {
            // 接收从 WebView 发送的消息
            Console.log("图片预览-------Received message from WebView-----------------------------: ${consoleMessage.message}");
          },
        )
    );
  }
}
