part of answer;


class AnswerPage extends StatefulWidget {
  final Map<String,String> params;
  const AnswerPage({
    Key? key,
    required this.params
  }) : super(key: key);

  @override
  State<AnswerPage> createState() => _AnswerPageState();
}

class _AnswerPageState extends State<AnswerPage> {

  @override
  void dispose() {
    CustomToast.dismiss();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
          appBar: AppBar(
            title: Text('${widget.params['title']}'),
          ),
          body: InAppWebView(
            initialUrlRequest: URLRequest(
              // url: Uri.parse(widget.params['url']??''),
                url: WebUri.uri(Uri.parse(widget.params['url']??''))
            ),
            initialSettings:InAppWebViewSettings(
              // http的请求也不做限制
                mixedContentMode:MixedContentMode.MIXED_CONTENT_ALWAYS_ALLOW
            ),
            onLoadStop: (controller, url) {
              String str = '$kServerUrl,${widget.params['book_id']},${widget.params['chapter_id']},${widget.params['token']},${widget.params['position']}';
              Console.log('知识测评--------传给前端的参数--------------------------------$str');
              controller.evaluateJavascript(source: 'callbackInFlutterComponent("$str");');

              controller.addJavaScriptHandler(handlerName: 'evaluatingSubmitCallback', callback: (args){
                Console.log('知识测评----提交按钮回调------------------------------------------------$args');
                context.pop();
                // readController.titleInput.text = args.toString();
              });
              controller.addJavaScriptHandler(handlerName: 'showLoadingCallback', callback: (args) async {
                CustomToast.loading();
              });
              controller.addJavaScriptHandler(handlerName: 'dismissLoadingCallback', callback: (args) async {
                CustomToast.dismiss();
              });
              // 答完题展示答题结果页
              controller.addJavaScriptHandler(handlerName: 'submitSuccessCallback', callback: (args) async {
                controller.loadUrl(urlRequest: URLRequest(
                    url: WebUri.uri(Uri.parse(kAnswerResult))
                ));
              });
            },
            onConsoleMessage: (controller, consoleMessage) {
              // 接收从 WebView 发送的消息
              Console.log("知识测评-------Received message from WebView-----------------------------: ${consoleMessage.message}");
            },
          )
      );
  }
}
