part of user_nick;

class UserNickPage extends StatefulWidget {
  final UserInfoModel userInfo;

  const UserNickPage({Key? key, required this.userInfo}) : super(key: key);

  @override
  State<UserNickPage> createState() => _UserNickPageState();
}

class _UserNickPageState extends State<UserNickPage> {
  final TextEditingController _textFieldController = TextEditingController();
  final FocusNode _focusNode = FocusNode();

  @override
  void initState() {
    super.initState();
    _textFieldController.text = widget.userInfo.name!;
    // 在这里可以使用 localVariable 进行操作
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserNickController>(
        init: UserNickController(widget.userInfo),
        builder: (controller) => Scaffold(
              appBar: CustomAppBar(
                title: const Text('设置昵称'),
                actions: [
                  Container(
                    height: 20.w,
                    width: 40.w,
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(10.w),
                        border: Border.all(color: Colours.c3, width: 0.5.w)),
                    child: Center(
                      child: GestureDetector(
                          onTap: () {
                            // print("保存昵称");
                            controller.changeInfo(_textFieldController.text);
                            _focusNode.unfocus();
                            Tools.unfocus();
                          },
                          child:  Text(
                            '保存',
                            style: TextStyle(
                                fontSize: 12.w, color: Colours.c3),
                          )),
                    ),
                  )
                ],
              ),
              body: Container(
                margin: EdgeInsets.only(left: AppTheme.margin,right: AppTheme.margin,top: AppTheme.margin),
                height: 42.w,
                decoration: BoxDecoration(boxShadow: [
                  BoxShadow(
                    color: Colours.cC7.withOpacity(0.5),
                    spreadRadius: 0.w,
                    blurRadius: 10.w,
                    offset: Offset(3.w, 0),
                  ),
                ], borderRadius: BorderRadius.circular(8.w), color: Colors.white),
                child: Container(
                  padding: EdgeInsets.only(
                    left: 15.w,
                    right: 15.w,
                  ),
                  child: Row(
                    children: [
                      Text(
                        '昵称',
                        style: TextStyle(fontSize: 14.w, color: Colours.c3),
                      ),
                      Gaps.hGaps15,
                      Expanded(
                        child: TextField(
                          controller: _textFieldController,
                          style:
                          TextStyle(fontSize: 14.w, color: Colours.c3),
                          decoration:  InputDecoration(
                              filled: true,
                              fillColor: Colors.transparent,
                              // 设置背景颜色为透明
                              hintText: '请输入昵称',
                              border: InputBorder.none,
                              enabledBorder: InputBorder.none,
                              focusedBorder: InputBorder.none,
                              suffixIconConstraints: BoxConstraints.tightFor(
                                  height: 15.w, width: 15.w)),
                          focusNode: _focusNode,
                        ),
                      ),
                      GestureDetector(
                        onTap: () {
                          // 处理点击事件，可以执行任意操作
                          _textFieldController.clear();
                          print('Image Clicked!');
                        },
                        child: Image(
                          image: const AssetImage('assets/images/del.png'),
                          height: 15.w,
                          width: 15.w,
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ));
  }
}
