part of user_order_awaiting;

/// 等待付款订单
class UserOrderAwaitingController extends GetxController {
  final String orderNum;

  UserOrderAwaitingController(this.orderNum); // 订单编号

  late OrderInfoModel model;
  // 应付款、订单编号等
  List<OrderCompletedModel> orderAwaitings = [];


  @override
  void onReady() {
    getOrderInfo();
    super.onReady();
  }

  ///  取消订单
  void cancelPay() async {
    final result = await MineAPI.cancelPay(ordersnum: orderNum);
    if (result) {
      Toast.show('取消成功');
      update();
    }
  }




  /// 获取订单信息
  void getOrderInfo() async {
    model = await MineAPI.getOrderInfo(orderNum: orderNum);
    String payWay ='';
    if(model.payType==1){
      payWay='微信';
    }else  if(model.payType==2){
      payWay='支付宝';
    }else  if(model.payType==3){
      payWay='紫荆币';
    }
    orderAwaitings = [
      OrderCompletedModel(name: '订单编号',value: model.ordersnum.toString()),
      OrderCompletedModel(name: '支付方式',value: payWay),
      OrderCompletedModel(name: '支付时间',value: model.payTime.toString()),
    ];

    update();
  }

}
