part of user_discuss_des;

class BuildDiscuss extends StatefulWidget {
  final DiscussModel model;
  final DiscussController? controller;
  final String bookId;
  final void Function(List<DiscussModel>?list, DiscussModel dModel)? onTapDel;
  final UserDiscussDesController? userDiscussDesController;
  const BuildDiscuss({
    Key? key,
    required this.model,
    this.controller,
    required this.bookId,
    this.userDiscussDesController,
    this.onTapDel,
  }) : super(key: key);

  @override
  State<BuildDiscuss> createState() => _BuildDiscussState();
}

class _BuildDiscussState extends State<BuildDiscuss> {
  final FocusNode _focusNode = FocusNode();

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 10.w,right: 10.w),
      padding:  EdgeInsets.all(10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4.w),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(1.5.w, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Slidable(
        enabled: widget.model.isMy == 1  ? true : false,
        endActionPane: ActionPane(
          motion: const ScrollMotion(),
          children: [
            SlidableAction(
              // An action can be bigger than the others.
              onPressed: (BuildContext context){
                if(widget.controller != null){
                  if (widget.onTapDel !=null) widget.onTapDel!(widget.controller?.discuss,widget.model);
                }
                if(widget.userDiscussDesController != null){
                  if (widget.onTapDel !=null) widget.onTapDel!(widget.userDiscussDesController?.discuss,widget.model);
                }
              },
              backgroundColor: const Color(0xFFAE1414),
              foregroundColor: Colors.white,
              // icon: Icons.archive,
              label: '删除',
            ),
          ],
        ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            RichText(text: TextSpan(
              children: [
                TextSpan(text: '话题：',style: TextStyle(
                    fontSize: 14.w,
                    height: 1.5.w,
                    color: Colours.c3,
                )),
                TextSpan(text: widget.model.title,style: TextStyle(
                    fontSize: 14.w,
                    height: 1.5.w,
                    color: Colours.c3,
                    fontWeight: Fonts.medium
                )),
              ]
            )),
            Gaps.vGaps10,
            Container(
              height: 0.5.w,
              color: Colours.cF2,
            ),
            _buildItem(widget.model,widget.model),
            Container(
              margin:EdgeInsets.only(left: 15.w),
                child: _buildListView(widget.model)
            ),
            Gaps.vGaps13,
            Container(
              width: double.infinity,
              padding: EdgeInsets.symmetric(vertical: 5.w,horizontal: 10.w),
              color: Colours.cF8,
              child:Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(widget.model.chapterName??'',style:  TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                  Text('内容：${widget.model.quoteContent??''}',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                ],
              )
            )
          ],
        ),
      ),
    );
  }

  Widget _buildItem(DiscussModel fatherModel, DiscussModel model,{int type =0}){
    return Slidable(
      enabled: type ==0?false: model.isMy == 1  ? true : false,
      endActionPane: ActionPane(
        motion: const ScrollMotion(),
        children: [
          SlidableAction(
            // An action can be bigger than the others.
            onPressed: (BuildContext context){
              if (widget.onTapDel !=null) widget.onTapDel!(fatherModel.commentAll,model);
            },
            backgroundColor: const Color(0xFFAE1414),
            foregroundColor: Colors.white,
            // icon: Icons.archive,
            label: '删除',
          ),
        ],
      ),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            margin: EdgeInsets.only(top: 10.w),
            child: ClipRRect(
              borderRadius: BorderRadius.circular(17.5.w),
              child: Container(
                width: 35.w,
                height: 35.w,
                child: CustomImage.network(url: model.personPic??'',placeholder: Image.asset('assets/images/user_default_icon.png'),),
              ),
            ),
          ),
          Expanded(
            child: Container(
              margin: EdgeInsets.only(left: 10.w,top: 10.w),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Row(
                        children: [
                          Text(model.personName??'',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                          Gaps.hGaps10,
                          type ==1?const SizedBox(): Text('发起人',style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary),)
                        ],
                      ),
                      Text(model.createTime??'',style:  TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),)
                    ],
                  ),
                  type ==0? Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      _showText(model).isEmpty?const SizedBox():Row(
                        children: [
                          Text(_showText(model),style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3),),
                          Text(_showStatus(model),style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary),),
                        ],
                      ),
                      Gaps.vGaps10,
                      _buildImageGridView()
                    ],
                  )
                  :RichText(text: TextSpan(
                    children: [
                      TextSpan(text: '回复 ',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                      TextSpan(text: model.replacePersonName??'',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c9)),
                      TextSpan(text: '：${_showText(model)}',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c3)),
                      TextSpan(text: _showStatus(model),style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary)),
                    ]
                  )),
                  SizedBox(height: 10.w,),
                  Row(
                    children: [
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          GestureDetector(
                            onTap: () async{
                              if (widget.controller?.canTap == true) {
                                widget.controller?.canTap = false;
                                await widget.controller?.commentLove(discussModel: model);
                                widget.controller?.canTap = true;
                              }
                              if (widget.userDiscussDesController?.canTap == true) {
                                widget.userDiscussDesController?.canTap = false;
                                await widget.userDiscussDesController?.commentLove(discussModel: model);
                                widget.userDiscussDesController?.canTap = true;
                              }
                            },
                            child: SizedBox(
                              height: 20.w,
                              width: 20.w,
                              // color: Colors.green,
                              child: Image.asset(model.isPraise ==0?'assets/images/unlove.png': 'assets/images/love.png',fit: BoxFit.cover,),
                            ),
                          ),
                          Text(model.goodNum.toString(),style: TextStyle(fontSize:12.w,height: 1.5,color: Colours.c9))
                        ],
                      ),
                      Gaps.hGaps15,
                      Row(
                        children: [
                          GestureDetector(
                            onTap:(){
                              // _showKeyboard(context);
                              // 阅读页讨论列表
                              widget.controller?.setShow();
                              widget.controller?.setDiscussModel(model);
                              widget.controller?.setFatherDiscussModel(fatherModel);
                              // 我的讨论详情页列表
                              widget.userDiscussDesController?.setShow();
                              widget.userDiscussDesController?.setDiscussModel(model);
                              widget.userDiscussDesController?.setFatherDiscussModel(fatherModel);
                            },
                            child: Container(
                              height: 25.w,
                              width: 15.w,
                              // color: Colors.yellow,
                              child: Image.asset('assets/images/reply.png',height: 15.w,width: 15.w,fit: BoxFit.fitWidth,),
                            ),
                          ),
                          SizedBox(width: 3.w,),
                          Text(model.replyNum.toString(),style: TextStyle(fontSize:12.w,height: 1.5,color: Colours.c9))
                        ],
                      )
                    ],
                  )
                ],
              ),
            ),
          )
        ],
      ),
    );
  }

  String _showText(DiscussModel discussModel){
    String text = '';
    // if(discussModel.isMy == 1){
    //   text = '${discussModel.content?.text?.content}';
    // }
    text = '${discussModel.content?.text?.content}';
    return text;
  }
  String _showStatus(DiscussModel discussModel){
    String text = '';
    // 是我的
    if(discussModel.isMy == 1){

      if(discussModel.privacyStatus ==-1){
        text = '(审核未通过)';

      }
      else if(discussModel.privacyStatus ==0){
        text = '(审核中)';
      }
      else if(discussModel.privacyStatus ==1){
        if(discussModel.commentsCheck == 1){
          if(discussModel.status == 0){
            text = '(审核中)';
          }
          else if(discussModel.status == 2){
            text = '(审核未通过)';
          }
        }
      }
    }
    return text;
  }

  String _showImageStatus(DiscussModel discussModel, MediaModel? mediaModel){
    String text = '';
    // 是我的
    if(discussModel.isMy == 1){

      if(discussModel.privacyStatus ==-1){
        text = '(审核未通过)';

      }
      else if(discussModel.privacyStatus ==0){
        text = '(审核中)';
      }
      else if(discussModel.privacyStatus ==1){
        if(discussModel.commentsCheck == 1){
          if(discussModel.status == 0){
            text = '(审核中)';
          }
          else if(discussModel.status == 2){
            text = '(审核未通过)';
          }
        }
      }
    }
    return text;
  }

  Widget _buildListView(DiscussModel model){
    List<DiscussModel> data = model.commentAll != null ?model.commentAll!:[];
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      itemBuilder: (BuildContext context,int index){
        return _buildItem(model,data[index],type: 1);
      },
      itemCount: data.length,
    );
  }

  // 图片
  Widget _buildImageGridView(){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 6,
          crossAxisSpacing: 2.w,
          mainAxisSpacing: 2.w,
          childAspectRatio: 1
      ),
      itemBuilder: (BuildContext context, int index) {
        MediaModel? mediaModel = widget.model.content?.image?[index];
        List<String>images = widget.model.content?.image?.map((MediaModel model) => model.content??'').toList()??[];
        return GestureDetector(
          onTap: (){
            context.pushNamed(Routes.imageView,extra:images,queryParameters: {'index': index.toString()});
          },
          child: Stack(
            children: [
              Positioned(
                  left: 0,
                  right:0,
                  top:0,
                  bottom: 0,
                  child: CustomImage.network(url: mediaModel?.content??'',fit: BoxFit.cover,)
              ),
              Visibility(
                visible: true,
                child: Positioned(
                    left: 0,
                    right:0,
                    top:0,
                    bottom: 0,
                    child: Container(
                      alignment: Alignment.center,
                      // color: widget.model.isMy==1?Colours.c9.withOpacity(0.5):Colours.c9.withOpacity(1),
                      child: Text(_showImageStatus(widget.model,mediaModel),style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary),),
                    )
                ),
              ),
            ],
          ),
        );
        // return Container(
        //   color: Colors.red,
        // );
      },
      itemCount: widget.model.content?.image?.length,
      // itemCount: 2,
    );
  }

  void _showKeyboard(BuildContext context) {
    _focusNode.requestFocus();
    FocusScope.of(context).requestFocus(_focusNode);
    Overlay.of(context)?.insert(
      OverlayEntry(
        builder: (context) => Positioned(
          bottom: MediaQuery.of(context).viewInsets.bottom,
          left: 0,
          right: 0,
          child: Container(
            color: Colors.white,
            child: Padding(
              padding: const EdgeInsets.all(8.0),
              child: TextField(
                focusNode: _focusNode,
                decoration: InputDecoration(
                  hintText: '在这里回复',
                  filled: true,
                  fillColor: Colors.grey[200],
                  border: OutlineInputBorder(
                    borderRadius: BorderRadius.circular(10.0),
                  ),
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }
}


