part of book_shop;

class BookShopPage extends StatefulWidget {
  const BookShopPage({Key? key}) : super(key: key);

  @override
  State<BookShopPage> createState() => _BookShopPageState();
}

class _BookShopPageState extends State<BookShopPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookshopController>(
      init: BookshopController(),
      builder: (controller) => Scaffold(
        appBar: AppBar(
          title: const Text('书架'),
        ),
        body: Column(
          children: [
            Expanded(
              child: controller.carts.isEmpty?Container(
                padding: EdgeInsets.only(top: 110.w),
                alignment: Alignment.center,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    SizedBox(height: 152.w, width: 195.w,
                      child: Image.asset( 'assets/images/none.png',),),
                    SizedBox(height: 13.w,),
                  ],
                ),
              ):ListView.builder(
                  itemBuilder: (BuildContext context,int index){
                    CourseModel model = controller.carts[index];
                    return GestureDetector(
                      onTap: (){
                        controller.select(model);
                      },
                      child: BookCell(model:model ,delTap: (){
                          controller.delCart(cartId: model.cartId.toString());
                      },),
                    );
                  },
                itemCount: controller.carts.length,
              ),
            ),
            SafeArea(child: BuildCounter(controller: controller,))
          ],
        ),
      ),
    );
  }

}
