part of library;

class LibraryController extends GetxController with GetTickerProviderStateMixin{
  
  // 分类数据
  List<CategoryModel> categories = [];
  // 标签数据
  List<LabelModel> labels = [];

  // 广告数组
  List<AdModel> ads = [];

  late LabelModel selectedLabel = LabelModel();

  late TabController tabController = TabController(length:categories.length, vsync: this);



  late AnimationController _controller;
  bool _show = false;

  bool get show => _show;
  void setShow(bool value) {
    _show = !value;
    if (_show) {
      /// 开启动画
      _controller.forward();
    }
    else {
      /// 收回动画
      _controller.reverse();
    }
    update();
  }


  AnimationController get controller => _controller;

  @override
  void onInit() {
    // 获取分类数据
    _getTabs();

    _controller = AnimationController(
      vsync: this,
      duration: const Duration(milliseconds: 100),
    );
    super.onInit();

  }

  @override
  void onReady() {
    // 获取标签数据
    _getLabels();
    _getAds();
    super.onReady();
  }

  @override
  void onClose() {
    tabController.dispose();
    super.onClose();
  }


  void selectLabel(LabelModel model){
    for (LabelModel m in labels){
      m.selected = false;
    }
    model.selected = true;
    selectedLabel = model;
    update();
  }

  /// 获取广告数据
  void _getAds() async {
    ads = await CommonAPI.list(type: '1');
    update();
  }

  /// 获取tab分类数据
  void _getTabs() async {
    categories = await LibraryAPI.categories();
    tabController.dispose();
    tabController = TabController(length:categories.length, vsync: this);
    update();
  }

  /// 获取标签数据
  void _getLabels() async {
    labels = await LibraryAPI.labels();
    selectedLabel = labels.first;
    selectedLabel.selected = true;
    update(['label']);
  }



}