part of user_notes_des;

class UserNotesDesController extends GetxController {
  final String tag;
  final CourseModel model;
  UserNotesDesController(this.tag,this.model);
  List<NoteModel> notes = [];

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  just_audio.AudioPlayer audioPlayer = just_audio.AudioPlayer();

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;


  @override
  void onReady() {
    onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    refreshController.dispose();
    audioPlayer.dispose();
    super.onClose();
  }

  // 播放音频
  void playAudio(MediaModel mediaModel){
    if(audioPlayer.playerState.playing){
      audioPlayer.stop();
      mediaModel.currentDuration = '0:00:00';
      // if(currentPlayMediaModel.id == mediaModel.id){
      //   return;
      // }
    }
    // 本地音频
    if (mediaModel.id == 0){
      audioPlayer.setFilePath(mediaModel.path);
    }
    // 远程音频
    else {
      audioPlayer.setUrl(mediaModel.content??'');
    }
    audioPlayer.play();
    audioPlayer.positionStream.listen((position) {
      String temp =  Tools.formatDuration(position);
      Console.log('播放时间---------------------$temp');
      mediaModel.currentDuration = temp;
      update();
    });
    // currentPlayMediaModel = mediaModel;
  }

  void delNotes({required String notesId,required String bookId}) async {
    final result = await MineAPI.delNotes(notesId: notesId, bookId: bookId);
    if (result){
      Toast.show('删除笔记成功');
      onRefresh();
    }
  }

  /// 获取笔记列表
  Future<void> _getNotes([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await MineAPI.noteList(
        page: _page,
        limit: _limit,
        bookId: model.bookId.toString(),
        types: tag
    );
    for(NoteModel noteModel in result){
      if(noteModel.noteContent!.audio!.isNotEmpty){
        for(MediaModel mediaModel in noteModel.noteContent!.audio!){
          Duration? duration = await just_audio.AudioPlayer().setUrl(mediaModel.content??'');

          mediaModel.duration = Tools.formatDuration(duration!);
        }
      }
    }
    // 如果是刷新 清理数据
    if (isRefresh) notes.clear();
    notes.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getNotes(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      Console.log('----error--------------------------------------$error--------------');
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getNotes();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }



}