part of mine;


class MinePage extends StatefulWidget {
  const MinePage({Key? key}) : super(key: key);

  @override
  State<MinePage> createState() => _MinePageState();
}

class _MinePageState extends State<MinePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<MineController>(
      init: MineController(),
        builder:(controller) => Stack(
          children: [
            Image.asset('assets/images/mine_bg.png'),
            Scaffold(
              backgroundColor:Colors.transparent,
              appBar: CustomAppBar(
                backgroundColor: Colors.transparent,
                actions: [
                  CustomButton.icon(
                    padding: EdgeInsets.zero,
                    backgroundColor: Colors.transparent,
                    icon: Image.asset(
                      'assets/images/read_history.png',
                    ),
                    onPressed: () => context.pushNamed(Routes.studyHistory),
                  ),
                  CustomButton.icon(
                    padding: EdgeInsets.zero,
                    backgroundColor: Colors.transparent,
                    icon: Image.asset(
                      'assets/images/set.png',
                    ),
                    onPressed: () => context.pushNamed(Routes.set),
                  ),
                  GestureDetector(
                    onTap: (){
                      context.pushNamed(Routes.msgs);
                      // controller.logout(context);
                    },
                    child: badges.Badge(
                      position: badges.BadgePosition.topEnd(top: -5, end: 0),
                      showBadge: controller.num == 0?false:true,
                      badgeContent: Text(controller.num.toString(),style: const TextStyle(fontSize: 7,color: Colors.white),),
                      badgeStyle: const badges.BadgeStyle(
                          badgeColor: AppTheme.primary,
                          shape: badges.BadgeShape.circle
                      ),
                      child: CustomButton.icon(
                        padding: EdgeInsets.zero,
                        backgroundColor: Colors.transparent,
                        icon: Image.asset(
                          'assets/images/msg_black.png',
                        ),
                        // onPressed: () => context.pushNamed(Routes.msgs),
                      ),
                    ),
                  )
                ],
              ),
              body: Container(
                color: Colors.transparent,
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      BuildUser(userInfo:controller.userInfo,onTap: (){
                        context.pushNamed(Routes.userInfo);
                      },),
                      Gaps.vGaps10,
                      BuildRead(items: controller.reads,onTap: (ReadModel model) async{
                        final result =  await context.pushNamed(model.link??'');
                        if (result == true){
                          controller.getInfo();
                        }
                      }),
                      controller.ads.isNotEmpty?Gaps.vGaps10:const SizedBox(),
                      controller.ads.isNotEmpty?
                      Container(
                        color: Colors.transparent,
                        padding: const EdgeInsets.symmetric(horizontal: 10),
                        child: BuildBanner(items:controller.ads),
                      ):const SizedBox(),
                      Gaps.vGaps5,
                      BuildAccount(items:controller.accounts,),
                      Gaps.vGaps10,
                      Container(
                        margin: const EdgeInsets.symmetric(horizontal: AppTheme.margin),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(8),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color: const Color(0xFFC7C7C7).withOpacity(0.5),
                              offset: const Offset(3, 0),
                              blurRadius: 10.w,
                              spreadRadius: 0.w,
                            ),
                          ],
                        ),
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(8),
                          child: Column(
                            children: [
                              GestureDetector(
                                onTap:(){
                                  context.pushNamed(Routes.security,extra: controller.userInfo);
                                }, child: _buildItem('账户安全')
                              ),
                              Container(color: Colours.cLine,margin: const EdgeInsets.symmetric(horizontal: 15),height: 1,),
                              _buildItem('意见反馈'),
                              Container(color: Colours.cLine,margin: const EdgeInsets.symmetric(horizontal: 15),height: 1,),
                              GestureDetector(
                                onTap: (){
                                  context.pushNamed(Routes.about);
                                }, child: _buildItem('关于我们',)
                              ),
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            )
          ],
        ),
    );
  }

  Widget _buildItem(String title) {
    return Container(
      padding: const EdgeInsets.only(left: 18,right: 15),
      color: Colors.white,
      height: 42,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Text(title,style: const TextStyle(fontSize: 14,color: Colours.c3,),),
          SizedBox(
            width: 5,
            height: 8,
            child: Image.asset('assets/images/right_arrow.png'),
          )
        ],
      ),
    );
  }

}
