part of user_info;

class UserInfoPage extends StatefulWidget {
  const UserInfoPage({Key? key}) : super(key: key);

  @override
  State<UserInfoPage> createState() => _UserInfoPageState();
}

class _UserInfoPageState extends State<UserInfoPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('个人信息'),
        centerTitle: true,
      ),
      body: Container(
        margin: const EdgeInsets.symmetric(horizontal: AppTheme.margin),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(8),
          color: Colors.white,
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            /// 头像
            Container(
              height: 52,
              padding: const EdgeInsets.only(left: 18,right: 15),
              child: GestureDetector(
                onTap: (){

                },
                child: Container(
                  color: Colors.transparent,
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      const Text('头像',style: TextStyle(color: Colours.c3,fontSize: 14,height: 1.6),),
                      Row(
                        children: [
                          Container(
                            width: 33.w,
                            height: 33.w,
                            decoration: const BoxDecoration(
                              shape: BoxShape.circle,
                              color: Colors.cyan,
                            ),
                          ),
                          Gaps.hGaps10,
                          Container(
                            width: 5,
                            height: 8,
                            color: Colors.cyan,
                          )
                        ],
                      )
                    ],
                  ),
                ),
              ),
            ),
            Container(color: Colours.cLine,margin: const EdgeInsets.symmetric(horizontal: 15),height: 1,),
            _buildItem('昵称', '随便起个名字', Routes.nike),
            Container(color: Colours.cLine,margin: const EdgeInsets.symmetric(horizontal: 15),height: 1,),
            _buildItem('性别', '男', 'linkTo'),
          ],
        ),
      )
    );
  }

  Widget _buildItem(String title, String value,String linkTo,{VoidCallback? onTap}) {
    return GestureDetector(
      onTap: (){
        if (linkTo.isNotEmpty){
          context.pushNamed(linkTo);
          if (onTap !=null) onTap;
        }
      },
      child: Container(
        padding: const EdgeInsets.only(left: 18,right: 15),
        color: Colors.transparent,
        height: 52,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Text(title,style: const TextStyle(fontSize: 14,color: Colours.c3,),),
            Row(
              children: [
                Text(value,style: const TextStyle(fontSize:14,color: Colours.c9,),),
                Gaps.hGaps10,
                Container(
                  width: 5,
                  height: 8,
                  color: Colors.cyan,
                )
              ],
            )

          ],
        ),
      ),
    );
  }
}
