part of user_security;


class UserSecurityPage extends StatefulWidget {
  final UserInfoModel model;
  const UserSecurityPage({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  State<UserSecurityPage> createState() => _UserSecurityPageState();
}

class _UserSecurityPageState extends State<UserSecurityPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('账号安全'),
      ),
      body: Column(
        children: [
          Container(
            margin: const EdgeInsets.symmetric(vertical: 10,horizontal: 10),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: const Offset(3, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: Column(
              children: [
               GestureDetector(
                 onTap:(){
                   context.pushNamed(Routes.changePhone);
                  },
                   child: _buildItem(title: '修改手机号码', value: widget.model.phone??'')
               ),
                Container(
                  margin: const EdgeInsets.symmetric(horizontal: 10),
                  height: 0.5,
                  color:Colours.cF0,
                ),
                GestureDetector(
                  onTap: (){
                    context.pushNamed(Routes.changePwd,queryParameters: {'type':widget.model.password.toString().isEmpty?'1':'2'});
                  },
                    child: _buildItem(title: '修改密码', value: widget.model.password.toString().isEmpty?'未设置':'')
                ),
              ],
            ),
          ),
          Container(
            margin: const EdgeInsets.symmetric(horizontal: 10),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: const Offset(3, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: Column(
              children: [
                _buildItem(title: '账号注销', value: ''),
              ],
            ),
          )
        ],
      ),
    );
  }

  Widget _buildItem({required String title,required String value}){
    return Container(
      margin: const EdgeInsets.only(left: 15,right: 15),
      color: Colors.white,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          GestureDetector(
            onTap: () async{

            },
            child: Container(
              color: Colors.white,
              height:45,
              alignment: Alignment.centerLeft,
              child: Text(title,style: const TextStyle(fontSize: 13,height: 1.5, color: Colours.c3)),
            ),
          ),
          Row(
            children: [
              Text(value,style: const TextStyle(fontSize: 13,height: 1.5,color: Colours.c9),),
              Gaps.hGaps10,
              Image.asset('assets/images/right_arrow.png')
            ],
          )
        ],
      ),
    );
  }
}
