part of version;


class VersionPage extends StatefulWidget {
  const VersionPage({Key? key}) : super(key: key);

  @override
  State<VersionPage> createState() => _VersionPageState();
}

class _VersionPageState extends State<VersionPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<VersionController>(
        init: VersionController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            centerTitle: true,
            title: const Text('版本介绍'),
          ),
          body: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child: SingleChildScrollView(
              child: Container(
                margin: const EdgeInsets.all(10),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                      color: const Color(0xFFC7C7C7).withOpacity(0.5),
                      offset: const Offset(3, 0),
                      blurRadius: 10.w,
                      spreadRadius: 0.w,
                    ),
                  ],
                ),
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(8),
                  child: ListView.builder(
                    shrinkWrap: true,
                    physics: const NeverScrollableScrollPhysics(),
                    itemCount: controller.versions.length,
                    itemBuilder: (BuildContext context, int index){
                      VersionModel model = controller.versions[index];
                      return GestureDetector(
                        child: BuildItem(model: model,),
                        onTap: (){
                          context.pushNamed(Routes.versionDes,extra: model);
                        },

                      );
                    }),
                ),
              ),
            ),
          ),
        ));
  }
}
