part of user_discuss_des;

class BuildListPage extends StatefulWidget {
  final String tag;
  final CourseModel model;
  const BuildListPage({
    Key? key,
    required this.tag,
    required this.model
  }) : super(key: key);


  @override
  State<BuildListPage> createState() => _BuildListPageState();
}

class _BuildListPageState extends State<BuildListPage> with AutomaticKeepAliveClientMixin{
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserDiscussDesController>(
      tag: widget.tag,
      init: UserDiscussDesController(widget.tag,widget.model),
      builder: (controller) =>CustomPullScrollView(
        controller: controller.refreshController,
        onRefresh: controller.onRefresh,
        onLoading: controller.onLoading,
        child: Stack(
          children: [
            ListView.builder(
              itemBuilder: (BuildContext context,int index){
                DiscussModel model = controller.discuss[index];
                return BuildDiscuss(
                  model: model,
                  bookId: widget.model.bookId.toString(),
                  userDiscussDesController: controller,
                  onTapDel: (DiscussModel dModel){
                    controller.delComment(discussModel: dModel);
                  },
                );
              },
              itemCount: controller.discuss.length,
            ),
            Visibility(
              visible: controller.showReply,
              child: Positioned(
                bottom: 0 ,
                left: 0,
                right: 0,
                top: 0,
                child: GestureDetector(
                  onTap: (){
                    controller.setShow();
                  },
                  child: Container(
                    color: const Color(0xFF000000).withOpacity(0.5),
                    child: SingleChildScrollView(
                      reverse: true,
                      child: GestureDetector(
                        behavior: HitTestBehavior.opaque,
                        onTap: (){},
                        child: Container(
                          color: Colors.white,
                          padding: EdgeInsets.only(bottom: MediaQuery.of(context).viewInsets.bottom),
                          child: Padding(
                            padding: const EdgeInsets.all(8.0),
                            child: Row(
                              children: [
                                Expanded(
                                  child:  TextField(
                                    autofocus: true,
                                    maxLines: null,
                                    controller: controller.replyInput,
                                    decoration: InputDecoration(
                                      border: InputBorder.none,
                                      enabledBorder: InputBorder.none,
                                      focusedBorder: InputBorder.none,
                                      hintText: '请输入内容',
                                      hintStyle:TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9,),
                                      filled: true,
                                      fillColor: Colours.cF8,
                                    ),
                                  ),
                                ),
                                Gaps.hGaps10,
                                GestureDetector(
                                  onTap: (){
                                    controller.submit();
                                    controller.setShow();
                                  },
                                  child: Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(15.w),
                                      color: AppTheme.primary,
                                      gradient: LinearGradient(
                                        colors: [const Color(0xFFD53676).withOpacity(0.9),AppTheme.primary] , // 不可点击时的颜色，透明度为0.7
                                        begin: Alignment.topCenter,
                                        end: Alignment.bottomCenter,
                                      ),
                                    ),
                                    padding:  EdgeInsets.symmetric(horizontal:13.5.w,vertical: 4.w),
                                    child:  Text('发表',style: TextStyle(fontSize: 14.w,fontWeight: Fonts.medium,color: Colors.white),),
                                  ),
                                )
                              ],
                            ),
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
              ),
            )
          ],
        )
      ),
    );
  }

  @override
  bool get wantKeepAlive => true;
}
