part of library;

class LibraryCell extends StatelessWidget {
  final CourseModel model;
  final void Function() onTap;
  const LibraryCell({
    Key? key,
    required this.model,
    required this.onTap
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.only(top: 10.w),
      height: 150.w,
      // color: Colors.red,
      child: Stack(
        children: [
          Container(
            padding: EdgeInsets.only(left: 10.w,top: 10.w,bottom: 20.w),
            margin: EdgeInsets.only(top:15.w,left: 10.w,right: 10.w),
            decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.circular(8.w),
              boxShadow: [
                BoxShadow(
                  color: Colours.cC7.withOpacity(0.5), // 阴影颜色
                  spreadRadius: 2.w, // 阴影扩散半径
                  blurRadius: 5.w, // 阴影模糊半径
                  offset: Offset(0, 2.w), // 阴影偏移
                ),
              ],

            ),
            child: Row(
              children: [
                /// 左侧
                Container(
                  width: 100.w,
                  height: 120.w,
                  color: Colors.white,
                ),
                /// 右侧
                Expanded(
                  child: Container(
                    margin: EdgeInsets.only(left: 10.w,right: 10.w),
                    // color: Colors.red,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      mainAxisSize: MainAxisSize.max,
                      children: [
                        // SizedBox(height: 10,),
                        Text(model.bookName??'',overflow: TextOverflow.ellipsis,maxLines: 2,style: TextStyle(fontSize: 14.w,fontWeight: Fonts.medium,height: 1.5,color: Colours.c3),),
                        // const SizedBox(height: 4,),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Expanded(child: Text(model.authors??'',style: TextStyle(fontSize: 11.w,color: Colours.c9,height: 1.5),overflow: TextOverflow.ellipsis,maxLines: 1,)),
                            Gaps.hGaps10,
                            Row(
                              children: [
                                Text('${model.readNum.toString()}人读过',style: TextStyle(fontSize: 11.w,height: 1.5,color: Colours.cC7)),
                                Gaps.hGaps5,
                                GestureDetector(
                                  onTap: onTap,
                                  child: SizedBox(
                                    width: 20.w,
                                    height: 20.w,
                                    // color: Colors.yellow,
                                    child: Image.asset(
                                      model.isCollection == 0? 'assets/images/unlove.png':'assets/images/love.png',
                                    ),
                                  ),
                                )
                              ],
                            )
                          ],
                        )
                      ],
                    ),
                  ),
                )
              ],
            ),
          ),
          Positioned(
            left: 20,
            top: 0,
            bottom: 18,
            child: CustomCard(
              width: 100.w,
              url: model.img??'',
            )
          ),
        ],
      )
    );
  }
}
