part of book_detail;



class BookDetailPage extends StatefulWidget {
  final String bookId;
  const BookDetailPage({
    Key? key,
    required this.bookId
  }) : super(key: key);

  @override
  State<BookDetailPage> createState() => _BookDetailPageState();
}

class _BookDetailPageState extends State<BookDetailPage> with SingleTickerProviderStateMixin{


  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookDetailController>(
      init:BookDetailController(widget.bookId),
      builder: (controller)=> Scaffold(
        appBar:  CustomAppBar(
          backgroundColor: const Color(0xFFAB1941).withOpacity(0.02),
          title: const Text('详情'),
          actions: [
            CustomButton.icon(
              padding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              icon: Image.asset('assets/images/shop.png'),
              onPressed: () => context.pushNamed(Routes.shop),
            ),
            CustomButton.icon(
              padding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              icon: Image.asset(
                controller.bookDetails.isCollection == 0? 'assets/images/unlove.png':'assets/images/love.png',
              ),
              onPressed: () {
                controller.love(bookId: controller.bookDetails.bookId.toString(), isCollection: controller.bookDetails.isCollection!);
              },
            ),
          ],
        ),
        body:
        Column(
          children: [
            BuildBook(model: controller.bookDetails,),
            Container(
              height: 10,
              color: const Color(0xFFF9F9F9),
            ),
            BuildStudy(model:controller.bookDetails,),
            Container(
              height: 2,
              color: const Color(0xFFF9F9F9),
            ),
            TabBar(
              labelColor: AppTheme.primary,
              // isScrollable: true,
              labelStyle: const TextStyle(fontSize: 15,height: 1.4,fontWeight: Fonts.medium),
              unselectedLabelColor: Colours.c9,
              unselectedLabelStyle: const TextStyle(fontSize: 15,height: 1.4),
              indicatorSize: TabBarIndicatorSize.label,
              indicatorColor: AppTheme.primary,
              tabs:controller.tabs,
              physics: const NeverScrollableScrollPhysics(),
              controller: controller.tabController,
            ),
            Expanded(
              child: TabBarView(
                controller: controller.tabController,
                children: [
                  BookCategoryPage(chapters: controller.chapters,),
                  Container(
                    margin: const EdgeInsets.only(left: 15,right: 15,top:12),
                    // color: Colors.lightBlue,
                    child: Text(controller.bookDetails.content??'',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c3),),
                  ),
                  BookInfoPage(model:controller.bookDetails,)
                ],
              ),
            ),

          ],
        ),
        bottomNavigationBar: SafeArea(
          child: Container(
            margin: const EdgeInsets.symmetric(horizontal: 15),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Expanded(
                  child: GestureDetector(
                    onTap: (){
                      context.pushNamed(Routes.studyReport);
                    },
                    child: Container(
                      alignment: Alignment.center,
                      height: 35,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5),
                        border:Border.all(
                          width: 0.5,
                          color: Colours.c9
                        ),
                        // color: Colours.cE0.withOpacity(0.5),
                      ),
                      // padding: EdgeInsets.symmetric(vertical: 8),
                      child: controller.bookDetails.isHave ==1? Text('学习报告',style: TextStyle(fontSize: 13,color: Colours.c9,height: 1.5),):Text('加入书架',style: TextStyle(fontSize: 13,color: AppTheme.primary,height: 1.5),),
                    ),
                  ),
                ),
                Gaps.hGaps10,
                Expanded(
                  child: GestureDetector(
                    onTap: (){
                      // context.pushNamed(Routes.creditPoints).then((value){
                      //   print('---------------------$value');
                      // });
                      /// 没有购买并且没有试读直接跳转 购买页
                      bool noTryRead = true;
                      if(controller.bookDetails.isHave == 0 && noTryRead){
                          context.pushNamed(Routes.bookPay);
                      }
                    },
                    child: Container(
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5),
                        color: AppTheme.primary.withOpacity(0.1)
                      ),
                      height: 35,
                      alignment: Alignment.center,
                      padding: const EdgeInsets.symmetric(vertical: 8),
                      child: const Text('阅读',style: TextStyle(fontSize: 13,color: AppTheme.primary,height: 1.5),),
                    ),
                  ),
                )
              ],
            ),
          ),
        ),
      ),
    );

  }



}
