part of book_pay;

class BookPayPage extends StatefulWidget {
  final List<CourseModel> buy;
  const BookPayPage({
    Key? key,
    required this.buy
  }) : super(key: key);

  @override
  State<BookPayPage> createState() => _BookPayPageState();
}

class _BookPayPageState extends State<BookPayPage> {

  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookPayController>(
      init: BookPayController(widget.buy),
      builder: (controller) => Scaffold(
        backgroundColor: Colours.cF9,
        appBar: AppBar(title: const Text('支付'),),
        body: SingleChildScrollView(
          child: Column(
            children: [
              ListView.builder(
                physics: const NeverScrollableScrollPhysics(),
                shrinkWrap:true,
                itemBuilder: (BuildContext context, int index){
                  return BuildItem(model: controller.buy[index],);
                },
                itemCount: controller.buy.length,
              ),

              const SizedBox(height: 10,),
              Container(
                margin: const EdgeInsets.only(left: 10,right: 10),
                decoration: BoxDecoration(
                    borderRadius:BorderRadius.circular(8),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colours.cC7.withOpacity(0.5),
                        spreadRadius: 2,
                        blurRadius: 5,
                        offset: const Offset(3, 0), // changes the position of the shadow
                      ),
                    ]
                ),
                child: Column(
                  children: [
                    _buildPointWidget(),
                    Container(height: 0.5,color: Colours.cF0,margin: const EdgeInsets.only(left: 10),),
                    _buildCouponWidget()
                  ],
                ),
              ),
              Container(
                margin: const EdgeInsets.only(left: 10,right: 10,top: 10),
                decoration: BoxDecoration(
                    borderRadius:BorderRadius.circular(8),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colours.cC7.withOpacity(0.5),
                        spreadRadius: 2,
                        blurRadius: 5,
                        offset: const Offset(3, 0), // changes the position of the shadow
                      ),
                    ]
                ),
                child: ListView.builder(
                  physics: const NeverScrollableScrollPhysics(),
                  padding: const EdgeInsets.symmetric(horizontal: 10),
                  shrinkWrap:true,
                  itemBuilder: (BuildContext context, int index){
                    PayModel model = controller.pays[index];
                    return GestureDetector(
                      onTap: (){
                        controller.setPayModel(model);
                      },
                        child: BuildPayWay(model:model,));
                  },
                  itemCount: controller.pays.length,
                ),
              ),
            ],
          ),
        ),
        bottomNavigationBar: SafeArea(child: BuildPayCount()),
      ),
    );
  }


  Widget _buildPointWidget(){
    return Container(
      margin: EdgeInsets.only(left: 13,right: 13),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Row(
            children: [
              Container(
                margin: const EdgeInsets.symmetric(vertical: 12),
                // color: Colors.cyan,
                width:20,
                height:20,
                child: Image.asset('assets/images/pay_coupon.png'),
              ),
              const SizedBox(width: 7,),
              const Text('优惠券',style:  TextStyle(fontSize: 14,color: Colours.c3,height: 1.1)),
            ],
          ),
          Container(
            // color: Colors.cyan,
            width:5,
            height:8,
            child: Image.asset('assets/images/right_arrow.png'),
          ),
        ],
      ),
    );
  }

  Widget _buildCouponWidget(){
    return Container(
      margin: EdgeInsets.only(left: 13,right: 13),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Row(
            children: [
              Container(
                margin: const EdgeInsets.symmetric(vertical: 12),
                // color: Colors.cyan,
                width:20,
                height:20,
                child: Image.asset('assets/images/pay_point.png'),
              ),
              const SizedBox(width: 7,),
              const Text('积分抵扣',style:  TextStyle(fontSize: 14,color: Colours.c3,height: 1.1)),
            ],
          ),
          Container(
            // color: Colors.cyan,
            width:5,
            height:8,
            child: Image.asset('assets/images/right_arrow.png'),
          ),
        ],
      ),
    );
  }
}
