part of book_pay;

class BuildPayWay extends StatelessWidget {
  final PayModel model;
  const BuildPayWay({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Container(
          padding: const EdgeInsets.symmetric(horizontal: 4),
          color: Colors.white,
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Row(
                children: [
                  Container(
                    margin: const EdgeInsets.symmetric(vertical: 12),
                    // color: Colors.cyan,
                    width:20,
                    height:20,
                    child: Image.asset(model.icon),
                  ),
                  const SizedBox(width: 7,),
                  Text(model.name,style: const TextStyle(fontSize: 14,color: Colours.c3,height: 1.1)),
                ],
              ),
              SizedBox(
                // color: Colors.cyan,
                width:15,
                height:15,
                child: Image.asset(model.selected?'assets/images/pay_check.png':'assets/images/pay_uncheck.png'),
              )
            ],
          ),
        ),
        Container(
          margin: const EdgeInsets.symmetric(horizontal:10),
          height: 0.5,
          color: Colours.cF0,
        )
      ],
    );
  }
}
