part of user_discuss;

class UserDiscussController extends GetxController {

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  List<CourseModel> discuss = [];

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;

  @override
  void onClose() {
    refreshController.dispose();
    super.onClose();
  }

  /// 获取讨论列表
  Future<void> _getNotes([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await MineAPI.discuss(
        page: _page,
        limit: _limit
    );
    // 如果是刷新 清理数据
    if (isRefresh) discuss.clear();
    discuss.addAll(_test());
    discuss.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getNotes(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getNotes();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

  List<CourseModel> _test(){
    return [
      CourseModel(),
      CourseModel(),
      CourseModel(),
    ];
  }
}