part of library;

class LibraryPage extends StatefulWidget {
  const LibraryPage({Key? key}) : super(key: key);

  @override
  State<LibraryPage> createState() => _LibraryPageState();
}

class _LibraryPageState extends State<LibraryPage> with AutomaticKeepAliveClientMixin,SingleTickerProviderStateMixin{

  List<String> _tabTag = ['全部','职业证书','人文艺术','财经管理'];

  List<Tab> get _tabs {
    return _tabTag.map<Tab>((item) => Tab(text: item,)).toList();
  }

  @override
  void initState() {
    _tabController = TabController(length:4, vsync: this);
    super.initState();
  }

  late TabController _tabController;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Container(
          color: Colors.limeAccent,
          height: 40,
        ),
        // leading: TextField(
        //
        //   style: TextStyle(
        //       color: Colors.cyan
        //   ),
        //   decoration: InputDecoration(
        //       hintText: '请输入手机号',
        //       prefixIcon: Icon(Icons.search),
        //       border:InputBorder.none,
        //       enabledBorder: InputBorder.none,
        //       focusedBorder: InputBorder.none
        //     // contentPadding: EdgeInsets.symmetric(vertical: 16.0),
        //   ),
        // ),
        actions: [
          IconButton(
            color: Colors.cyan,
            icon: const Icon(Icons.message),
            tooltip: 'Open shopping cart',
            onPressed: () {
            },
          ),
          IconButton(
            color: Colors.cyan,
            icon: const Icon(Icons.refresh),
            tooltip: 'Open shopping cart',
            onPressed: () {
            },
          ),
        ],
      ),
      body: Container(
        margin: EdgeInsets.all(10),
        child: SingleChildScrollView(
            child: Column(
              children: [
                Container(
                  color: Colors.cyan,
                  height: 150,
                  margin: EdgeInsets.only(bottom: 10),
                ),
                HomeCard(title: '人气推荐1',),
                HomeCard(title: '人气推荐2',),
                HomeCard(title: '人气推荐3',),
                HomeCard(title: '人气推荐4',)
              ],
            )
        ),
      ),
    );
  }

  /// 列表
  Widget createListView(){
    return ListView.builder(
      itemBuilder: (BuildContext context, int index){
        return LibraryCell();
      },
      itemCount: 2,
    );
  }

  /// 分类
  Widget scaffold (){
    return Scaffold(
      appBar: AppBar(
        title: const Text('图书馆',style: TextStyle(
            color: Colors.white
        ),),
        flexibleSpace: Container(
          decoration: const BoxDecoration(
              gradient: LinearGradient(
                  begin: Alignment.topCenter,
                  end: Alignment.bottomCenter,
                  colors: [Color(0xFFEE5982),Color(0xFFAB1941)]
              )
          ),
        ),
        actions: [
          IconButton(
            color: Colors.white,
            icon: const Icon(Icons.search),
            tooltip: 'Open shopping cart',
            onPressed: () {
            },
          ),
        ],
        bottom: PreferredSize(
          preferredSize: Size.fromHeight(48),
          child: Container(
            color: Colors.white,
            width: double.infinity,
            child: Row(
              children: [
                Expanded(
                  child: TabBar(
                    indicator: BoxDecoration(
                        border: Border(bottom: BorderSide(color: Colors.transparent, width: 0.0)), // 将指示器的底边框颜色设置为透明
                        color: Colors.lightBlue
                    ),
                    unselectedLabelColor: Colors.grey,
                    controller: _tabController,
                    // isScrollable: true,
                    tabs: [
                      Tab(text: '全部'),
                      Tab(text: '职业证书'),
                      Tab(text: '人文艺术'),
                      Tab(text: '财经管理'),
                      // Tab(text: '待评价'),
                      // Tab(text: '待评价1'),
                      // Tab(text: '待评价2'),
                    ],
                  ),
                ),
                GestureDetector(
                  child: Container(
                    child: Text('分类'),
                  ),
                )
              ],
            ),
          ),
        ),
      ),
      body: TabBarView(
        controller: _tabController,
        children: [
          // 第一个分类的内容
          LibraryCell(),
          // 第二个分类的内容
          Center(child: Text('分类2内容')),
          // 第三个分类的内容
          Center(child: Text('分类3内容')),
          Center(child: Text('分类4内容')),
          // Center(child: Text('分类5内容')),
          // Center(child: Text('分类5内容')),
          // Center(child: Text('分类5内容')),
        ],
      ),
    );
  }

  @override
  // TODO: implement wantKeepAlive
  bool get wantKeepAlive => true;
}
