part of user_msg;

class BuildItem extends StatelessWidget {
  const BuildItem({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10,right: 10,top:10),
      padding: EdgeInsets.symmetric(horizontal: 10,vertical: 10),
      height: 75,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: Colors.white
      ),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          badges.Badge(
            position: badges.BadgePosition.topEnd(top: 0, end: 0),
            badgeStyle: const badges.BadgeStyle(
                badgeColor: AppTheme.primary,
                shape: badges.BadgeShape.circle
            ),
            child: Container(
              width: 30,
              height: 30,
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(15),
                  color: AppTheme.primary.withOpacity(0.1)
              ),
              child: Image.asset(
                'assets/images/msg.png',
              ),
            ),
          ),
          Gaps.hGaps10,
          Expanded(
            child: const Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text('积分过期提醒',style: TextStyle(fontSize: 15,height: 1.4,fontWeight: Fonts.medium,color: Colours.c3),),
                    Text('2023-12-12',style: TextStyle(fontSize:11,height: 1.4,color: Colours.c9))
                  ],
                ),
                Gaps.vGaps5,
                Text('您有2000积分即将过期。',style: TextStyle(fontSize: 13,height: 1.4,color: Colours.c6),)
              ],
            ),
          )
        ],
      ),
    );
  }
}
