part of book_shop;


class BuildCounter extends StatelessWidget {
  final BookshopController controller;
  const BuildCounter({
    Key? key,
    required this.controller
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.white,
      padding: EdgeInsets.only(left: 20.w,right: 15.w),
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Row(
                children: [
                 GestureDetector(
                   onTap: (){
                     controller.selectAll();
                   },
                   child: Container(
                     color: Colors.white,
                     child: Row(
                       children: [
                         SizedBox(
                           height: 17.w,
                           width: 17.w,
                           child: Image.asset(controller.all?'assets/images/pay_check.png':'assets/images/pay_uncheck.png',fit: BoxFit.cover,),
                         ),
                         SizedBox(width: 11.w),
                         Text('全选',style: TextStyle(color: const Color(0xFF333333),fontSize: 14.w,fontWeight: Fonts.boldSemi)),
                       ],
                     ),
                   ),
                 ),
                  SizedBox(width: 15.w,),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text('合计 ￥${controller.allPrice.toStringAsFixed(2)}',style: const TextStyle(color: AppTheme.primary,fontSize: 16,fontWeight: Fonts.boldSemi)),
                      Text('已选 ${controller.num} 件',style: const TextStyle(color: Color(0xFF999999),fontSize: 12,))
                    ],
                  )
                ],
              ),
              GestureDetector(
                onTap: () async {
                  if (controller.num > 0){
                    final  result = await context.pushNamed(Routes.bookPay,extra: controller.buy);
                    if (result == true) {
                      controller.getCart();
                    }
                  }
                },
                child: Container(
                  margin: EdgeInsets.symmetric(vertical: 9.w),
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(17.5.w),
                      color: AppTheme.primary
                  ),
                  // height: 35,
                  alignment: Alignment.center,
                  padding: EdgeInsets.symmetric(vertical: 8.w,horizontal: 20.w),
                  child:  Text('结算(${controller.num})',style: TextStyle(fontSize: 12.w,color: Colors.white,height: 1.1,fontWeight: Fonts.medium),),
                ),
              )
            ],
          ),
          Container(
            height: 1.w,
            color: const Color(0xFFF9F9F9),
          )
        ],
      ),
    );
  }
}
