part of web;

class BuildItem extends StatefulWidget {
  final ChapterModel model;
  final Function(ChapterModel chapterModel) onTapChapter;
  const BuildItem({
    Key? key,
    required this.model,
    required this.onTapChapter
  }) : super(key: key);

  @override
  State<BuildItem> createState() => _BuildItemState();
}

class _BuildItemState extends State<BuildItem> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        /// 章节名称容器
        GestureDetector(
          onTap: (){
            if(widget.model.children!.isEmpty){
              widget.onTapChapter(widget.model);
            }
          },
          child: Container(
            padding: EdgeInsets.symmetric(horizontal: 15.w),
            height: 30.w,
            color: Colors.white,
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Text(widget.model.name??'',style: TextStyle(fontSize: 14.w,color: widget.model.seen ==0? Colours.c3:Colours.c9,fontWeight: Fonts.boldSemi,height: 2),),
                    Gaps.hGaps5,
                    widget.model.isReading == 1? Container(
                      height: 18,
                      width: 18,
                      margin: EdgeInsets.only(top: 6.w),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8.5.w),
                        border: Border.all(width:1,color: AppTheme.primary)
                      ),
                      child: Text('试',style: TextStyle(fontSize: 11.w,color: AppTheme.primary),),
                    ):const SizedBox(),
                  ],
                ),
                Transform.rotate(
                    angle: widget.model.selected?0:-90 * (3.141592653589793 / 180),
                    child: GestureDetector(
                      onTap: (){
                        setState(() {
                          widget.model.selected = !widget.model.selected;
                        });
                      },
                      child: SizedBox(
                        width: 20,
                        height: 20,
                        child: Image.asset('assets/images/down.png')
                      ),
                    )
                )

              ],
            )
          ),
        ),
        /// 节的名称容器
        Visibility(
          visible: widget.model.selected,
            child: ListView.builder(
              shrinkWrap: true,
              physics: const NeverScrollableScrollPhysics(),
                itemBuilder: (BuildContext context, int index){
                  ChapterModel model = widget.model.children![index];
                  return GestureDetector(
                    onTap: (){
                      widget.onTapChapter(model);
                    },
                    child: _buildSection(model)
                  );
                },
                itemCount: widget.model.children!.length,
            )
        )
      ],
    );
  }

  Widget _buildSection(ChapterModel model){
    return Container(
      color: Colors.white,
      padding: const EdgeInsets.only(left: 60),
      child: Text(model.name??'',style:TextStyle(fontSize: 14,color: model.seen ==0? Colours.c3:Colours.c9,height: 2),),
    );
  }
}
