part of user_order;

/// 订单详情
class UserSearchController extends GetxController
    with GetTickerProviderStateMixin {

  List<OrderListModel> orderList = [];


  late TextEditingController searchController = TextEditingController();

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;




  @override
  void onReady() {
    // onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    searchController.dispose();
    super.onClose();
  }

  /// 获取订单列表
  Future<void> _getOrders({bool isRefresh = false, String keys ='',}) async {
    // 网路请求
    final result = await MineAPI.orderList(
        page: _page, limit: _limit, status: 0, keys: keys);
    orderList.clear();
    orderList.addAll(result);
    _page++;
    _noMore = result.length < _limit;
    update();
  }


}
