part of change_phone;


class ChangePhonePage extends StatefulWidget {
  const ChangePhonePage({Key? key}) : super(key: key);

  @override
  State<ChangePhonePage> createState() => _ChangePhonePageState();
}

class _ChangePhonePageState extends State<ChangePhonePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ChangePhoneController>(
      init: ChangePhoneController(),
      builder: (controller) =>Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('修改手机号'),
        ),
        body: Container(
          margin: EdgeInsets.only(left: 10.w, right: 10.w,top: 15.w),
          child: Column(
            children: [
              Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8.w),
                  color: const Color(0xFFF9F9F9),
                  boxShadow: [
                    BoxShadow(
                      color: const Color(0xFFC7C7C7).withOpacity(0.35),
                      offset: Offset(3.w, 0),
                      blurRadius: 10.w,
                      spreadRadius: 0.w,
                    ),
                  ],
                ),
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(8.w),
                  child: CustomFormInput(
                    // label: 'Phone',
                    // required: true,
                    hintText: '请输入新的手机号',
                    keyboardType: TextInputType.number,
                    controller: controller.phoneInput,
                    onChanged: (text){
                      controller.setCanClick();
                    },
                    decoration: const InputDecoration(
                      focusedBorder: InputBorder.none,
                      border: InputBorder.none,
                      enabledBorder: InputBorder.none,
                      errorBorder: InputBorder.none
                    )
                  ),
                ),
              ),
              Gaps.vGaps10,
              Stack(
                alignment: Alignment.centerRight,
                children: [
                  Container(
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(8.w),
                      color: const Color(0xFFF9F9F9),
                      boxShadow: [
                        BoxShadow(
                          color: const Color(0xFFC7C7C7).withOpacity(0.35),
                          offset: Offset(3.w, 0),
                          blurRadius: 10.w,
                          spreadRadius: 0.w,
                        ),
                      ],
                    ),
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(8.w),
                      child: CustomFormInput(
                        // label: 'Phone',
                        // required: true,
                        hintText: '请输入验证码',
                        keyboardType: TextInputType.number,
                        controller: controller.codeInput,
                        decoration: const InputDecoration(
                        focusedBorder: InputBorder.none,
                        border: InputBorder.none,
                        enabledBorder: InputBorder.none,
                        errorBorder: InputBorder.none
                        ),
                        onChanged: (text){
                          controller.setCanClick();
                        },
                      ),
                    ),
                  ),
                  Positioned(
                      right: 10.w,
                      child: Row(
                        children: [
                          Container(height: 20.w,width: 1.w,color: const Color(0xFFEBEBEB),),
                          Gaps.hGaps10,
                          GestureDetector(
                            child: Container(
                                padding: EdgeInsets.symmetric(vertical: 10.w),
                                // color: Colors.yellow,
                                child: Text(controller.isCounting?'${controller.countDown}':'获取验证码',style: TextStyle(fontSize: 11.w,color: AppTheme.primary,height: 1.4),)),
                            onTap: (){
                              if (controller.isCounting == false){
                                controller.sendCode();
                              }
                            },
                          ),
                        ],
                      )
                  ),
                ],
              ),
              Gaps.vGaps40,
              CustomGradientButton(
                text: '确认修改',
                isEnabled: controller.enable,
                onPressed: () async {
                  Tools.unfocus();
                  final result = await controller.changePhone();
                  if (result){
                    Toast.show('修改成功');
                    context.pop();
                  }

                },
              )
            ],
          ),
        ),
      ),
    );
  }
}
