part of web;

class ReadController extends FullLifeCycleController with GetSingleTickerProviderStateMixin{

  // 目录
  List <ChapterModel> chapters = [];

  // late final PageController pageController;
  //
  // //默认显示
  // int currentPage = 1;


  late AnimationController _controller;
  bool _show = true;

  bool get show => _show;
  void setShow(bool value) {
    _show = !value;
    if (_show) {
      /// 显示状态栏
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.edgeToEdge);
      /// 开启动画
      _controller.forward();
    }
    else {
      /// 不显示状态栏
      // SystemChrome.setEnabledSystemUIMode(SystemUiMode.immersiveSticky);
      /// 收回动画
      _controller.reverse();
    }
    update();
  }


  AnimationController get controller => _controller;


  @override
  void onInit() {
    // pageController = PageController(initialPage: currentPage);

    /// 默认不显示状态栏
    // SystemChrome.setEnabledSystemUIMode(SystemUiMode.immersiveSticky);
    /// 初始化
    _controller = AnimationController(
      vsync: this,
      duration: const Duration(milliseconds: 100),
    );
    super.onInit();
  }

  @override
  void onReady() {
    _getChapters();
    super.onReady();
  }

  @override
  void onClose() {
    _controller.dispose();
    super.onClose();
  }


  void onPageChanged(int page) {
    // currentPage = page;
    update(['navigation']);
  }

  void onResumed(){
    print('onResumed');
  }
  void onPaused(){
    print('onPaused');
  }
  void onInactive(){
    print('onInactive');
  }
  void onDetached(){
    print('onDetached');
  }



  /// 获取目录信息
  void _getChapters() async {
    chapters = await LibraryAPI.chapters(bookId: '110');
    update();
  }
}