part of mine;

class BuildAccount extends StatelessWidget {
  final List<ReadModel> items ;
  final void Function()? onTap;
  const BuildAccount({
    super.key,
    this.onTap,
    this.items = const []
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: AppTheme.margin),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color:Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: const Offset(3, 0),
            blurRadius: 10.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            padding: const EdgeInsets.only(left: 17,top: 14,bottom: 14,right: 17),
            child: const Text('我的账户',style: TextStyle(color: Colours.c3,fontSize: 16,height: 1.6,fontWeight: Fonts.medium),),
          ),
          Container(
            padding: const EdgeInsets.only(bottom: 13,top: 5),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: items.map((model){
                return GestureDetector(
                  onTap: (){
                    if (model.link != null){
                      context.pushNamed(model.link!);
                      if (onTap !=null) onTap;
                    }
                  },
                  child: Column(
                    children: [
                      SizedBox(
                        width: 25.w,
                        height: 25.w,
                        // color: Colors.green,
                        child: Image.asset(model.icon!),
                      ),
                      Gaps.vGaps5,
                      Text(model.name,style: TextStyle(fontSize:12.w,height: 1.6,color: Colours.c9),),
                      items.indexOf(model) == 0?Row(
                        children: [
                          Text(model.value.toString(),style: const TextStyle(fontSize: 16,height: 1.6,fontWeight: Fonts.medium,color: AppTheme.primary,),),
                          const Text('张',style: TextStyle(fontSize: 12,height:1.6,color: Colours.c3),)
                        ],
                      ):Text(model.value.toString(),style: const TextStyle(fontSize: 16,height:1.6,color: Colours.c3),)
                    ],
                  ),
                );
              } ).toList(),
            ),
          )
        ],
      ),
    );
  }
}
