part of user_notes;

class UserNotePage extends StatefulWidget {
  const UserNotePage({Key? key}) : super(key: key);

  @override
  State<UserNotePage> createState() => _UserNotePageState();
}

class _UserNotePageState extends State<UserNotePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserNoteController>(
      init: UserNoteController(),
      builder:(controller)=> Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('笔记'),
        ),
        body: CustomPullScrollView(
            controller: controller.refreshController,
            // onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child:SingleChildScrollView(
              child: Container(
                margin: const EdgeInsets.all(10),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                      color: const Color(0xFFC7C7C7).withOpacity(0.5),
                      offset: const Offset(3, 0),
                      blurRadius: 10.w,
                      spreadRadius: 0.w,
                    ),
                  ],
                ),
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(8),
                  child: ListView.builder(
                    physics: const NeverScrollableScrollPhysics(),
                    shrinkWrap: true,
                    itemBuilder: (BuildContext context, int index){
                      return GestureDetector(
                        onTap: (){
                          context.pushNamed(Routes.noteDes,extra: controller.notes[index]);
                        },
                          child: BuildItem(model: controller.notes[index],index: index,num: controller.notes.length,)
                      );
                    },
                    itemCount: controller.notes.length,
                  ),
                ),
              ),
            )
        ),
      ),
    );
  }
}
