part of user_edit_note;

class UserEditNotePage extends StatefulWidget {
  final NoteModel model;
  final String bookId;
  const UserEditNotePage({
    Key? key,
    required this.model,
    required this.bookId,
  }) : super(key: key);

  @override
  State<UserEditNotePage> createState() => _UserEditNotePageState();
}

class _UserEditNotePageState extends State<UserEditNotePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserEditNoteController>(
      init: UserEditNoteController(widget.model,widget.bookId),
      builder:(controller)=> Scaffold(
        appBar: AppBar(
          title: const Text('笔记编辑'),
          centerTitle: true,
        ),
        body: Container(
            color: Colors.white,
            margin: EdgeInsets.symmetric(horizontal: 10.w),
            child: Stack(
              children: [
                SingleChildScrollView(
                  padding:EdgeInsets.only(bottom: 100.w),
                  child: Container(
                    // color: Colours.cF8,
                    constraints: BoxConstraints(
                        minHeight: 100.w
                    ),
                    child: Column(
                      children: [
                        TextField(
                          // focusNode: widget.controller.discussContentFocusNode,
                          maxLines: null,
                          autofocus: true,
                          controller: controller.contentInput,
                          decoration: InputDecoration(
                            border: InputBorder.none,
                            enabledBorder: InputBorder.none,
                            focusedBorder: InputBorder.none,
                            hintText: '请输入内容',
                            hintStyle:TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9,),
                            filled: true,
                            // fillColor: Colours.cF8,
                          ),
                        ),
                        Column(
                          children: [
                            GridView.builder(
                              // padding: const EdgeInsets.only(left: 13,top: 10),
                              physics: const NeverScrollableScrollPhysics(),
                              shrinkWrap: true,
                              gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                                  crossAxisCount: 3,
                                  crossAxisSpacing: 2.w,
                                  mainAxisSpacing: 2.w,
                                  childAspectRatio: 1
                              ),
                              itemBuilder: (BuildContext context, int index) {
                                MediaModel mediaModel = controller.model.noteContent!.image![index];
                                return Stack(
                                  children: [
                                    Positioned(
                                        left:0,
                                        right: 0,
                                        top:0,
                                        bottom: 0,
                                        child: mediaModel.id == 0?CustomImage.file(url:mediaModel.path): CustomImage.network(url: mediaModel.content??'')
                                    ),
                                    Positioned(
                                        right: 0.w,
                                        top: 0.w,
                                        child: GestureDetector(
                                            onTap: (){
                                              controller.delImage(mediaModel);
                                            },
                                            child: Image.asset('assets/images/media_del.png',width: 17.w,height: 17.w,)
                                        )
                                    )
                                  ],
                                );
                              },
                              itemCount: controller.model.noteContent?.image?.length,
                            ),
                            MediaQuery.removePadding(
                              context: context,
                              removeTop: true,
                              child: ListView.builder(
                                physics: const NeverScrollableScrollPhysics(),
                                shrinkWrap: true,
                                itemBuilder: (BuildContext context, int index){
                                  MediaModel mediaModel = controller.model.noteContent!.audio![index];
                                  return Container(
                                    // height: 20.w,
                                    margin: EdgeInsets.only(right: 130.w,),
                                    child: Stack(
                                      children: [
                                        Container(
                                          decoration: BoxDecoration(
                                            borderRadius: BorderRadius.circular(10.w),
                                            color: Colours.cF9,
                                          ),
                                          padding: EdgeInsets.only(right:20.w,left: 10.w),
                                          margin: EdgeInsets.only(top: 10.w,right: 10.w),
                                          height: 20,
                                          child: Row(
                                            // mainAxisSize: MainAxisSize.min,
                                            mainAxisAlignment:MainAxisAlignment.spaceBetween,
                                            children: [
                                              GestureDetector(
                                                onTap:(){
                                                  controller.playAudio(mediaModel);
                                                },
                                                child: Image.asset('assets/images/audio.png')
                                              ),
                                              Text('${mediaModel.currentDuration}/${mediaModel.duration}',style: TextStyle(fontSize: 10.w,height: 1.4,color: Colours.c9),)
                                            ],
                                          ),
                                        ),
                                        Positioned(
                                          right: 6,
                                          top: 6,
                                          child: GestureDetector(
                                            onTap: (){
                                              controller.delAudio(mediaModel);
                                            },
                                            child: Image.asset('assets/images/media_del.png',width: 12.w,height: 12.w,)
                                          )
                                        )
                                      ],
                                    ),
                                  );
                                },
                                itemCount: controller.model.noteContent?.audio?.length,
                              ),
                            )
                          ],
                        )
                      ],
                    ),
                  ),
                ),
                Visibility(
                  visible: true,
                  child: Positioned(
                    left: 0,
                    right: 0,
                    bottom: 0,
                    child: Container(
                      color: Colors.white,
                      padding: EdgeInsets.symmetric(vertical: 10.w),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          Row(
                            children: [
                              GestureDetector(
                                  onTap: () async{
                                    final assets = await AssetsPicker.image(
                                      context: context,
                                    );
                                    controller.addImage(assets!.path);
                                  },
                                  child: SizedBox(
                                    // color: Colors.red,
                                      width: 25,
                                      height: 25,
                                      child: Image.asset('assets/images/read_add_img.png',fit: BoxFit.contain,)),
                              ),
                              Gaps.hGaps10,
                              GestureDetector(
                                  onTap: () async {
                                    if(controller.startRecording){
                                      controller.stopRecorder();
                                    }
                                    else {
                                      controller.record();

                                    }
                                  },
                                  child: SizedBox(
                                      width: 23,
                                      height: 23,
                                    child: Image.asset(controller.startRecording?'assets/images/stop.png':'assets/images/read_add_audio.png',fit: BoxFit.contain,)
                                  )
                              ),
                              GestureDetector(
                                onTap: (){
                                  controller.setIsPublic();
                                },
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: [
                                    Gaps.hGaps10,
                                    SizedBox(
                                      width: 15,
                                      height: 15,
                                      child: Image.asset(controller.isPublic?'assets/images/pay_check.png':'assets/images/public.png',fit: BoxFit.contain,)
                                    ),
                                    SizedBox(width: 3.w,),
                                    Text('公开',style: TextStyle(fontSize: 13.w,height: 1.3,color: Colours.c9),)
                                  ],
                                ),
                              )
                            ],
                          ),
                          GestureDetector(
                            onTap: () async{
                             final result = await controller.submit();
                             if (result){
                               Tools.unfocus();
                               Toast.show('修改成功');
                               context.pop();
                             }
                            },
                            child: Container(
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(15.w),
                                color: AppTheme.primary,
                                gradient: LinearGradient(
                                  colors: [const Color(0xFFD53676).withOpacity(0.9),AppTheme.primary] , // 不可点击时的颜色，透明度为0.7
                                  begin: Alignment.topCenter,
                                  end: Alignment.bottomCenter,
                                ),
                              ),
                              padding:  EdgeInsets.symmetric(horizontal:13.5.w,vertical: 4.w),
                              child:  Text('发表',style: TextStyle(fontSize: 14.w,fontWeight: Fonts.medium,color: Colors.white),),
                            ),
                          )
                        ],
                      ),
                    ),
                  ),
                )
              ],
            )
        ),
      ),
    );
  }
}
