part of web;

class ReadInputDiscuss extends StatefulWidget {
  final ReadController controller;
  const ReadInputDiscuss({
    Key? key,
    required this.controller,
  }) : super(key: key);

  @override
  State<ReadInputDiscuss> createState() => _ReadInputDiscussState();
}

class _ReadInputDiscussState extends State<ReadInputDiscuss> {
  @override
  Widget build(BuildContext context) {
    return Container(
        color: Colors.white,
        margin: EdgeInsets.symmetric(horizontal: 15.w),
        child: Column(
          children: [
            Container(
              margin: EdgeInsets.symmetric(vertical: 10.w),
              child: widget.controller.chatType ==0?Row(
                children: [
                  Text('话题',style: TextStyle(fontSize: 14.w,color: Colours.c3,height: 1.5,fontWeight: Fonts.medium),),
                  Gaps.hGaps5,
                  Expanded(
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(4),
                      child: TextField(
                        focusNode: widget.controller.discussTitleFocusNode,
                        controller: widget.controller.titleInput,
                        autofocus: true,
                        decoration: InputDecoration(
                          border: InputBorder.none,
                          enabledBorder: InputBorder.none,
                          focusedBorder: InputBorder.none,
                          hintText: '请输入话题名称',
                          hintStyle:TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9,),
                          filled: true,
                          fillColor: Colours.cF8,
                        ),
                        onSubmitted: (_){
                          FocusScope.of(context).requestFocus(widget.controller.discussContentFocusNode);
                        },
                      ),
                    ),
                  ),
                ],
              ):Text('"${widget.controller.noteTitle}"',style: TextStyle(fontSize: 12.w,height: 1.4,color: Colours.c9),),
            ),
            ClipRRect(
              borderRadius: BorderRadius.circular(4.w),
              child: Container(
                color: Colours.cF8,
                constraints: BoxConstraints(
                    minHeight: 100.w
                ),
                child: Column(
                  children: [
                    TextField(
                      focusNode: widget.controller.discussContentFocusNode,
                      maxLines: null,
                      autofocus: widget.controller.chatType ==0?false:true,
                      controller: widget.controller.contentInput,
                      decoration: InputDecoration(
                        border: InputBorder.none,
                        enabledBorder: InputBorder.none,
                        focusedBorder: InputBorder.none,
                        hintText: '请输入内容',
                        hintStyle:TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9,),
                        filled: true,
                        fillColor: Colours.cF8,
                      ),
                    ),
                    Column(
                      children: [
                        MediaQuery.removePadding(
                          context: context,
                          removeTop: true,
                          child: GridView.builder(
                            // padding: const EdgeInsets.only(left: 13,top: 10),
                            physics: const NeverScrollableScrollPhysics(),
                            shrinkWrap: true,
                            gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                                crossAxisCount: 6,
                                crossAxisSpacing: 2.w,
                                mainAxisSpacing: 2.w,
                                childAspectRatio: 1
                            ),
                            itemBuilder: (BuildContext context, int index) {
                              return Stack(
                                children: [
                                  Positioned(
                                    left:0,
                                    right: 0,
                                    top:0,
                                    bottom: 0,
                                    child: CustomImage.file(url:widget.controller.discussInputImages[index])
                                  ),
                                  Positioned(
                                    right: 5.w,
                                    top: 5.w,
                                    child: GestureDetector(
                                      onTap: (){
                                        widget.controller.delDiscussInputImages(widget.controller.discussInputImages[index]);
                                      },
                                      child: Image.asset('assets/images/del_close.png',width: 12.w,height: 12.w,)
                                    )
                                  )
                                ],
                              );
                            },
                            itemCount: widget.controller.discussInputImages.length,
                          ),
                        ),
                        Container(
                          color: Colors.red,
                          child: MediaQuery.removePadding(
                            context: context,
                            removeTop: true,
                            child: ListView.builder(
                              physics: const NeverScrollableScrollPhysics(),
                              shrinkWrap: true,
                              itemBuilder: (BuildContext context, int index){
                                return Container(
                                  height: 20.w,
                                  margin: EdgeInsets.only(right: 130.w),
                                  child: Container(
                                    margin: EdgeInsets.only(top: 5.w),
                                    padding: EdgeInsets.only(right:20.w,left: 10.w),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(10.w),
                                      color: Colours.cF9,
                                    ),
                                    child: Row(
                                      // mainAxisSize: MainAxisSize.min,
                                      mainAxisAlignment:MainAxisAlignment.spaceBetween,
                                      children: [
                                        Image.asset('assets/images/audio.png'),
                                        Text('0:00/1:52',style: TextStyle(fontSize: 10.w,height: 1.4,color: Colours.c9),)
                                      ],
                                    ),
                                  ),
                                );
                              },
                              itemCount: 0,
                            ),
                          ),
                        )
                      ],
                    )
                  ],
                ),
              ),
            ),
            Container(
              padding: EdgeInsets.symmetric(vertical: 10.w),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Row(
                    children: [
                      GestureDetector(
                        onTap: () async{
                          final assets = await AssetsPicker.image(
                            context: context,
                          );
                          widget.controller.addDiscussInputImages(assets!.path);
                        },
                        child: Image.asset('assets/images/read_add_img.png')),
                      Gaps.hGaps10,
                      GestureDetector(
                        onTap: () async {

                        },
                        child: Image.asset('assets/images/read_add_audio.png')
                      ),
                      widget.controller.chatType ==0?const SizedBox():GestureDetector(
                        onTap: (){
                          widget.controller.setIsPublic();
                        },
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Gaps.hGaps10,
                            Image.asset(widget.controller.isPublic?'assets/images/pay_check.png':'assets/images/pay_uncheck.png'),
                            SizedBox(width: 3.w,),
                            Text('公开',style: TextStyle(fontSize: 13.w,height: 1.3,color: Colours.c9),)
                          ],
                        ),
                      )
                    ],
                  ),
                  GestureDetector(
                    onTap: (){
                      widget.controller.submit();
                    },
                    child: Container(
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(15.w),
                        color: AppTheme.primary,
                        gradient: LinearGradient(
                          colors: [const Color(0xFFD53676).withOpacity(0.9),AppTheme.primary] , // 不可点击时的颜色，透明度为0.7
                          begin: Alignment.topCenter,
                          end: Alignment.bottomCenter,
                        ),
                      ),
                      padding:  EdgeInsets.symmetric(horizontal:13.5.w,vertical: 4.w),
                      child:  Text('发表',style: TextStyle(fontSize: 14.w,fontWeight: Fonts.medium,color: Colors.white),),
                    ),
                  )
                ],
              ),
            )
          ],
        )
    );
  }
}
