part of search;

class BuildHistory extends StatefulWidget {
  const BuildHistory({super.key});

  @override
  State<BuildHistory> createState() => _BuildHistoryState();
}

class _BuildHistoryState extends State<BuildHistory> {

  // List<String> _searchList = [];

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SearchController>(
      init: SearchController(),
      builder:(controller)=> Container(
        margin: const EdgeInsets.only(left: 13,top: 18),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                const Text('搜索历史',style: TextStyle(fontSize: 14,height: 1.5,color: Colours.c3,fontWeight: Fonts.medium),),
                GestureDetector(
                  onTap: (){
                    controller.clearHistory();
                  },
                  child: Container(
                    padding: EdgeInsets.all(10),
                    // width: 10,
                    // height: 10,
                    // color: Colors.cyan,
                    child: Image.asset(
                      'assets/images/del.png',
                    ),
                  ),
                )
              ],
            ),
            Wrap(
              spacing: 10,
              runSpacing: 10,
              alignment: WrapAlignment.start,
              runAlignment: WrapAlignment.start,
              children: _buildItem(controller.searchList),
            ),
          ],
        ),
      ),
    );
  }

  List <Widget> _buildItem(List<String> searchList){
    print(searchList);
    if (searchList == null || searchList.isEmpty){
      List<Widget> list = [
        Container(
          width: 0,
          height: 0,
        )
      ];
      return list;
    }else {
      return searchList.map((e){
        return GestureDetector(
          child: Container(
            height: 27,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(13.5),
              color: Colours.cF4
            ),
            child: Padding(
              padding: const EdgeInsets.symmetric(horizontal:15,vertical: 5),
              child: Text(e,style: const TextStyle(fontSize: 13,height: 1.4,color: Colours.c3),textAlign: TextAlign.center,),
            ),
          ),
        );
      }).toList();
    }
  }
}
