part of store;

class UserStore extends GetxController {
  // 获取 UserStore 实例
  static UserStore get to => Get.find();
  
  // 是否登录
  bool _isLogin = false;

  String _token = '';
  String get token => _token;


  String _accessToken = '';
  String get accessToken => _accessToken;


  bool get isLogin=> _isLogin;
  bool get hasToken => _token.isNotEmpty;

  UserModel _info = UserModel();
  UserModel get info => _info;

  
  
  @override
  void onInit() {
    super.onInit();
    _token = StorageService.to.getString(kLocalToken);
  }

  Future<void> setToken(String value) async {
    await StorageService.to.setString(kLocalToken, value);
    _token = value;
  }

  Future<void> setAccessToken(String value) async {
    await StorageService.to.setString(kLocalAccessToken, value);
    _accessToken = value;
  }

  Future<void> setInfo(UserModel value) async {
    await StorageService.to.setString(kLocalUserInfo, jsonEncode(value.toJson()));
    _info = value;
  }

  // 登出
  Future<void> logout() async {
    await StorageService.to.remove(kLocalToken);
    await StorageService.to.remove(kLocalAccessToken);
    await StorageService.to.remove(kLocalUserInfo);
    _token = '';
    _isLogin = false;
  }

  Future<void> profile() async {
    
    print('toknen----------------------: ' + _token);
    if (!hasToken) return;
    _isLogin = true;
    update();
  }

  
}